/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzOfferInfo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzOfferInfoExportDetailVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzOfferInfoExportMainVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzOfferInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 瓜子offer信息接收表
 *
 * @author chenyx
 * @date 2025-06-11 15:58:37
 */
@Mapper
public interface TGzOfferInfoMapper extends BaseMapper<TGzOfferInfo> {
    /**
     * 瓜子offer信息接收表简单分页查询
     * @param tGzOfferInfo 瓜子offer信息接收表
     * @return IPage<TGzOfferInfoVo>
     */
    IPage<TGzOfferInfoVo> getTGzOfferInfoPage(Page<TGzOfferInfoVo> page, @Param("tGzOfferInfo") TGzOfferInfoVo tGzOfferInfo);
    TGzOfferInfoVo getInfoById(@Param("id") Integer id);

	/**
	 * 瓜子offer信息接收表简单分页查询
	 * @param tGzOfferInfo 瓜子offer信息接收表
	 * @return IPage<TGzOfferInfoVo>
	 */
	List<TGzOfferInfoVo> getTGzOfferInfoSendAlertList(@Param("tGzOfferInfo") TGzOfferInfoVo tGzOfferInfo);

	/**
	 * 获取指定条数限制的列表
	 * @param tGzOfferInfo 瓜子offer信息接收表
	 * @return List<TGzOfferInfoVo>
	 */
	List<TGzOfferInfoVo> getTGzOfferInfoListHaveLimit(@Param("tGzOfferInfo") TGzOfferInfoVo tGzOfferInfo,
													  @Param("limitCount") Integer limitCount);

	/**
	 * 获取指定条数限制的列表
	 * @param tGzOfferInfo 瓜子offer信息接收表
	 * @return List<TGzOfferInfoVo>
	 */
	Integer getTGzOfferInfoCount(@Param("tGzOfferInfo") TGzOfferInfoVo tGzOfferInfo);


    int getTGzOfferCount(@Param("tGzOfferInfo") TGzOfferInfoVo tGzOfferInfo);

    List<TGzOfferInfoExportMainVo> getTGzOfferMainList(@Param("tGzOfferInfo") TGzOfferInfoVo tGzOfferInfo);

    List<TGzOfferInfoExportDetailVo> getTGzOfferDetailList(@Param("tGzOfferInfo") TGzOfferInfoVo tGzOfferInfo);

}
