/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysCspDeptVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProjectBelongDept;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeProjectScpVO;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeProjectBelongDeptSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.UserPermissionVo;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 项目档案所属部门表
 *
 * @author hgw
 * @date 2025-02-28 15:03:17
 */
public interface TEmployeeProjectBelongDeptService extends IService<TEmployeeProjectBelongDept> {
	/**
	 * 项目档案所属部门表简单分页查询
	 *
	 * @param tEmployeeProjectBelongDept 项目档案所属部门表
	 * @return
	 */
	IPage<EmployeeProjectScpVO> getTEmployeeProjectBelongDeptPage(Page<EmployeeProjectScpVO> page
			, TEmployeeProjectBelongDeptSearchVo tEmployeeProjectBelongDept);

	/**
	 * @Description: CSP导出花名册
	 * @Author: hgw
	 * @Date: 2025/3/3 9:39
	 * @return: void
	 **/
	void listExport(HttpServletResponse response, TEmployeeProjectBelongDeptSearchVo searchVo);

	/**
	 * 获取部门下花名册总数
	 *
	 * @param tEmployeeProjectBelongDept 花名册查询
	 * @return Integer 花名册总数
	 */
	Integer getDeptCount(TEmployeeProjectBelongDeptSearchVo tEmployeeProjectBelongDept);

	/**
	 * 根据权限获取对应部门ID下的花名册总数Map
	 *
	 * @param tEmployeeProjectBelongDept 花名册查询
	 * @return Map<String, Integer> 对应部门ID下的花名册总数Map
	 */
	Map<String, Integer> getDeptCountMap(TEmployeeProjectBelongDeptSearchVo tEmployeeProjectBelongDept, UserPermissionVo authority);

	/**
	 * 没有关联部门的花名册总数
	 *
	 * @param tEmployeeProjectBelongDept 花名册查询
	 * @return Integer 花名册总数
	 */
	Integer getNoneDeptCount(TEmployeeProjectBelongDeptSearchVo tEmployeeProjectBelongDept);

	Boolean saveOrDeleteDeptRelation(SysCspDeptVo vo);

}
