package com.yifu.cloud.plus.v1.yifu.common.dapr.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * @Author hgw
 * @Date 2022-7-27 19:38:08
 * @Description
 * @Version 1.0
 */
@Data
@Component
@PropertySource("classpath:daprConfig.properties")
@ConfigurationProperties(value = "dapr.social", ignoreInvalidFields = false)
public class DaprSocialProperties {
	/*
	 * @author fxj
	 * @date  14:34
	 * @Description  dapr sidercar url  如：http://localhost:3005/v1.0/invoke/
	 **/
	String appUrl;
	/*
	 * @author fxj
	 * @date  14:35
	 * @decription  app_id  如："yifu_upms_sider"
	 **/
	String appId;

	String appPort;

	String httpPort;

	String grpcPort;

	String metricsPort;
}
