/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 工资明细表
 *
 * @author fxj
 * @date 2024-03-08 18:05:39
 */
@Data
@TableName("ekp_salary_info")
@EqualsAndHashCode()
@Schema(description = "工资明细表")
public class EkpSalaryInfo {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "fd_id")
	private String fd_id;
	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String fd_3adfedf98ccba2;
	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String fd_3adfedf9d2bf1c;
	/**
	 * 单号
	 */
	@Schema(description = "单号")
	private String fd_3adfedfa4410aa;
	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String fd_3adfedfacd65d6;
	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String fd_3adfedfb174068;
	/**
	 * 姓名
	 */
	@Schema(description = "姓名")
	private String fd_3adfedfb5a68a2;
	/**
	 * 身份证号
	 */
	@Schema(description = "身份证号")
	private String fd_3adfedfb8f76d4;
	/**
	 * 手机号
	 */
	@Schema(description = "手机号")
	private String fd_3adfedfbd23ab8;
	/**
	 * 银行卡号
	 */
	@Schema(description = "银行卡号")
	private String fd_3adfedfcb17f1e;
	/**
	 * 开户行
	 */
	@Schema(description = "开户行")
	private String fd_3adfedfc453cc4;
	/**
	 * 工资月份
	 */
	@Schema(description = "工资月份")
	private String fd_3adfee063acff0;
	/**
	 * 实际结算月份
	 */
	@Schema(description = "实际结算月份")
	private String fd_3adfee0690737c;
	/**
	 * 是否薪资扣税
	 */
	@Schema(description = "是否薪资扣税")
	private String fd_3adfee01668666;
	/**
	 * 社保优先级
	 */
	@Schema(description = "社保优先级")
	private String fd_3adfedfed8bb28;
	/**
	 * 公积金优先级
	 */
	@Schema(description = "公积金优先级")
	private String fd_3adfedff3a7430;
	/**
	 * 是否自有员工
	 */
	@Schema(description = "是否自有员工")
	private String fd_3adfee0009d070;
	/**
	 * 年终奖扣税方案
	 */
	@Schema(description = "年终奖扣税方案")
	private String fd_3adfee01dea2fa;
	/**
	 * 应发工资
	 */
	@Schema(description = "应发工资")
	private Double fd_3adfee12cb8840;
	/**
	 * 个人代扣
	 */
	@Schema(description = "个人代扣")
	private Double fd_3adfee1374ed7a;
	/**
	 * 单位社保
	 */
	@Schema(description = "单位社保")
	private Double fd_3adfee1e2b2f78;
	/**
	 * 个人社保
	 */
	@Schema(description = "个人社保")
	private Double fd_3adfee1e88723e;
	/**
	 * 单位公积金
	 */
	@Schema(description = "单位公积金")
	private Double fd_3adfee1ee24680;
	/**
	 * 个人公积金
	 */
	@Schema(description = "个人公积金")
	private Double fd_3adfee1f32fa24;
	/**
	 * 个税
	 */
	@Schema(description = "个税")
	private Double fd_3adfee1f901c46;
	/**
	 * 企业年金单位
	 */
	@Schema(description = "企业年金单位")
	private Double fd_3adfee1ff1ca6a;
	/**
	 * 企业年金个人
	 */
	@Schema(description = "企业年金个人")
	private Double fd_3adfee203f86b2;
	/**
	 * 实发合计
	 */
	@Schema(description = "实发合计")
	private Double fd_3adfee20fe5ba4;
	/**
	 * 应收
	 */
	@Schema(description = "应收")
	private Double fd_3adfee21802434;
	/**
	 * 收入结算状态
	 */
	@Schema(description = "收入结算状态")
	private String fd_3adfee4ba5ad36;
	/**
	 * 收款状态
	 */
	@Schema(description = "收款状态")
	private String fd_3adfee4c0c59ee;
	/**
	 * 收入结算单号
	 */
	@Schema(description = "收入结算单号")
	private String fd_3adfee5dd14866;
	/**
	 * 收款单号
	 */
	@Schema(description = "	收款单号")
	private String fd_3adfee5e3d1638;
	/**
	 * 代扣费用应支出
	 */
	@Schema(description = "代扣费用应支出")
	private Double fd_3adfeeb34ea0ea;
	/**
	 * 代扣费用结算状态
	 */
	@Schema(description = "代扣费用结算状态")
	private String fd_3adfeededfb5a6;
	/**
	 * 代扣费用付款状态
	 */
	@Schema(description = "代扣费用付款状态")
	private String fd_3adfeed3a20598;
	/**
	 * 个税应支出
	 */
	@Schema(description = "个税应支出")
	private Double fd_3adfeec6db8766;
	/**
	 * 个税结算状态
	 */
	@Schema(description = "个税结算状态")
	private String fd_3adfeef8ef38fc;
	/**
	 * 个税付款状态
	 */
	@Schema(description = "个税付款状态")
	private String fd_3adfeedd08222c;
	/**
	 * 实发合计应支出
	 */
	@Schema(description = "	实发合计应支出")
	private Double fd_3adfeec730ec44;
	/**
	 * 工资实发结算状态
	 */
	@Schema(description = "工资实发结算状态")
	private String fd_3adfeef9440ab2;
	/**
	 * 实发合计付款状态
	 */
	@Schema(description = "实发合计付款状态")
	private String fd_3adfeedd5f3cb2;
	/**
	 * 企业年金单位应支出
	 */
	@Schema(description = "企业年金单位应支出")
	private Double fd_3adfeec782070a;
	/**
	 * 企业年金单位结算状态
	 */
	@Schema(description = "企业年金单位结算状态")
	private String fd_3adfeef9b9fb3e;
	/**
	 * 企业年金单位付款状态
	 */
	@Schema(description = "企业年金单位付款状态")
	private String fd_3adfeeddacf6d4;
	/**
	 * 企业年金个人应支出
	 */
	@Schema(description = "企业年金个人应支出")
	private Double fd_3adfeec7ccdd1c;
	/**
	 * 企业年金个人结算状态
	 */
	@Schema(description = "企业年金个人结算状态")
	private String fd_3adfeefa1eba32;
	/**
	 * 企业年金个人付款状态
	 */
	@Schema(description = "企业年金个人付款状态")
	private String fd_3adfeede08d430;
	/**
	 * 代扣费用付款单号
	 */
	@Schema(description = "代扣费用付款单号")
	private String fd_3aea309696d32e;
	/**
	 * 代扣费用结算单号
	 */
	@Schema(description = "代扣费用结算单号")
	private String fd_3aea30866d0c30;
	/**
	 * 年金单位结算单号
	 */
	@Schema(description = "年金单位结算单号")
	private String fd_3aeadf182ef6a2;
	/**
	 * 年金个人付款单号
	 */
	@Schema(description = "年金个人付款单号")
	private String fd_3aeadf1992544c;
	/**
	 * 实发结算单号
	 */
	@Schema(description = "实发结算单号")
	private String fd_3aeadf17522642;
	/**
	 * 年金个人结算单号
	 */
	@Schema(description = "年金个人结算单号")
	private String fd_3aeadf191c62a0;
	/**
	 * 个税支出结算单号
	 */
	@Schema(description = "个税支出结算单号")
	private String fd_3aeadede4cea84;
	/**
	 * 个税支出付款单号
	 */
	@Schema(description = "个税支出付款单号")
	private String fd_3aeadee1cf1266;
	/**
	 * 年金单位付款单号
	 */
	@Schema(description = "年金单位付款单号")
	private String fd_3aeadf1892fdb2;
	/**
	 * 实发付款单号
	 */
	@Schema(description = "实发付款单号")
	private String fd_3aeadf17b7d03a;
	/**
	 * 暂停发
	 */
	@Schema(description = "暂停发")
	private String fd_3af9d5874f8166;
	/**
	 * 是否垫付
	 */
	@Schema(description = "是否垫付")
	private String fd_3afaa69ad4d16a;
	/**
	 * 税务主体
	 */
	@Schema(description = "税务主体")
	private String fd_3afab16f356672;
	/**
	 * 工资id
	 */
	@Schema(description = "工资id")
	private String fd_3b10afe8c70742;
	/**
	 * 是否全部结算
	 */
	@Schema(description = "是否全部结算")
	private String fd_3b13b1b91f5b34;
	/**
	 * HRO结算月份
	 */
	@Schema(description = "HRO结算月份")
	private String fd_3b13b1d1ff9678;
	/**
	 * 代扣个人社保
	 */
	@Schema(description = "代扣个人社保")
	private Double fd_3b16cecc2bbd16;
	/**
	 * 代扣个人公积金
	 */
	@Schema(description = "代扣个人公积金")
	private Double fd_3b16cecd47a856;
	/**
	 * 项目台账ID(ID)
	 */
	@Schema(description = "项目台账ID(ID)")
	private String fd_3b16e418905f52;
	/**
	 * 项目台账ID
	 */
	@Schema(description = "项目台账ID")
	private String fd_3b16e418905f52_text;
	/**
	 * 是否为BPO业务
	 */
	@Schema(description = "是否为BPO业务")
	private String fd_3b178f3e24cc32;
	/**
	 * 薪酬申请编号
	 */
	@Schema(description = "薪酬申请编号")
	private String fd_3b3beee3ec7e12;
	/**
	 * 开户行支行
	 */
	@Schema(description = "开户行支行")
	private String fd_3b73c214e52982;
	/**
	 * 初始化导入
	 */
	@Schema(description = "初始化导入")
	private String fd_3b84d6a6c7b8f0;
	/**
	 * 变更说明
	 */
	@Schema(description = "变更说明")
	private String fd_3b9893328ffb46;
	/**
	 * 发放方式
	 */
	@Schema(description = "发放方式")
	private String fd_3bbc0711464020;
	/**
	 * 实发工资（现金）
	 */
	@Schema(description = "实发工资（现金）")
	private String fd_3bcd2e63600446;
	/**
	 * 单位待补足
	 */
	@Schema(description = "单位待补足")
	private String fd_3bcd2e64868de6;
	/**
	 * 实发工资（银付）
	 */
	@Schema(description = "实发工资（银付）")
	private String fd_3bcd2e6259fdbe;
	/**
	 * 代扣单位社保
	 */
	@Schema(description = "代扣单位社保")
	private String fd_3bcd2f1a073260;
	/**
	 * 个人代扣明细
	 */
	@Schema(description = "个人代扣明细")
	private String fd_3bcd2f180f2a8c;
	/**
	 * 代扣单位公积金
	 */
	@Schema(description = "代扣单位公积金")
	private String fd_3bcd3102f612ea;
	/**
	 * 免个税个人代扣
	 */
	@Schema(description = "免个税个人代扣")
	private String fd_3bcd2ef618ee54;
	/**
	 * 个人社保（不含代扣）
	 */
	@Schema(description = "个人社保（不含代扣）")
	private String fd_3bcd3119a295be;
	/**
	 * 应发工资（导表金额）
	 */
	@Schema(description = "应发工资（导表金额）")
	private String fd_3bcdeed22ec8dc;
	/**
	 * 暂停发金额
	 */
	@Schema(description = "暂停发金额")
	private String fd_3bcd34a8c296c8;
	/**
	 * 代扣个人年终奖税
	 */
	@Schema(description = "代扣个人年终奖税")
	private String fd_3bcd2ef8728fe0;
	/**
	 * 个人代扣合计
	 */
	@Schema(description = "个人代扣合计")
	private String fd_3bcd2f18fd1840;
	/**
	 * 单位社保（不含代扣）
	 */
	@Schema(description = "单位社保（不含代扣）")
	private String fd_3bcd3100f45ca2;
	/**
	 * 代扣当月个人税
	 */
	@Schema(description = "代扣当月个人税")
	private String fd_3bcd2ef727ac6a;
	/**
	 * 单位公积金（不含代扣）
	 */
	@Schema(description = "单位公积金（不含代扣）")
	private String fd_3bcd3101d95dd8;
	/**
	 * 个人公积金（不含代扣）
	 */
	@Schema(description = "个人公积金（不含代扣）")
	private String fd_3bcd311a72d000;
	/**
	 * 前端客服
	 */
	@Schema(description = "前端客服")
	private String fd_3bee2056eeb800;
	/**
	 * 创建人
	 */
	@Schema(description = "创建人")
	private String fd_3c3e5ff65115a2;

	@Schema(description ="创建时间")
	private Date createTime;
}
