package com.yifu.cloud.plus.v1.ekp.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.ListUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.ekp.entity.EkpSalaryInfo;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpSalaryInfoMapper;
import com.yifu.cloud.plus.v1.ekp.service.EkpSalaryInfoService;
import com.yifu.cloud.plus.v1.ekp.vo.ClaimInfotVO;
import com.yifu.cloud.plus.v1.ekp.vo.ClaimRebackInfotVO;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
//工资明细表
 *
//@author huyc
//@date 2024-03-11 11:21:56
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class

EkpSalaryInfoServiceImpl extends ServiceImpl<EkpSalaryInfoMapper, EkpSalaryInfo> implements EkpSalaryInfoService {

	/**
	//@Description: 工资明细推送至ekp
	//@Author: huyc
	//@Date: 2024-3-11
	//@return: void
	 **/
	public Boolean pushSalaryInfoToEkp(List<EkpSalaryParam> unPushList) {

		//插入数据集合
		List<EkpSalaryInfo> salaryInfoList = new ArrayList<>();

		//获取ekp所有项目信息
		List<EkpDeptInfoVo> deptInfoVoList = baseMapper.getAllEkpDeptInfo();
		Map<String,EkpDeptInfoVo> map = new HashMap<>();
		EkpDeptInfoVo deptInfo;
		if (Optional.ofNullable(deptInfoVoList).isPresent()) {
			map = deptInfoVoList.stream().collect(Collectors.toMap(EkpDeptInfoVo::getDeptNo, k->k));
		}
		EkpSalaryInfo salaryInfoCount;
		try {
			for (EkpSalaryParam salaryParam : unPushList) {
				//去重 防止重复推送
				salaryInfoCount = baseMapper.selectOne(Wrappers.<EkpSalaryInfo>query().lambda()
						.eq(EkpSalaryInfo::getFd_3b10afe8c70742, salaryParam.getFd_3b10af838eab5c())
						.last(CommonConstants.LAST_ONE_SQL));
				if (Optional.ofNullable(salaryInfoCount).isPresent()) {
					continue;
				}
				EkpSalaryInfo salaryInfo = new EkpSalaryInfo();
				//对象信息赋值
				copySocialProperties(salaryParam, salaryInfo);

				//项目信息
				deptInfo = map.get(salaryInfo.getFd_3adfedf98ccba2());
				if (Common.isEmpty(deptInfo)) {
					continue;
				}
				salaryInfo.setFd_3b16e418905f52_text(deptInfo.getDeptName());
				salaryInfo.setFd_3b16e418905f52(deptInfo.getFdId());
				//实际结算月份
				salaryInfo.setFd_3adfee0690737c(!"全量未结算数据".equals(deptInfo.getSocialType()) ? salaryInfo.getFd_3adfee0690737c() : "");
				//是否全部结算
				salaryInfo.setFd_3b13b1b91f5b34("全量未结算数据".equals(deptInfo.getSocialType()) ? "是" : "否");
				//应收
				salaryInfo.setFd_3adfee21802434("是".equals(salaryInfo.getFd_3b178f3e24cc32()) ? CommonConstants.ZERO_INTEGER.doubleValue() : salaryInfo.getFd_3adfee20fe5ba4());

				//代扣费用应支出 = $个人社保$ Fd_3adfee1e88723e + $单位公积金$ Fd_3adfee1ee24680 + $个人公积金$ Fd_3adfee1f32fa24 + $单位社保$ Fd_3adfee1e2b2f78 + $个人代扣$ Fd_3adfee1374ed7a
				BigDecimal zhichu1 = Common.isEmpty(salaryInfo.getFd_3adfee1e88723e()) ? BigDecimal.ZERO : BigDecimal.valueOf(salaryInfo.getFd_3adfee1e88723e());
				BigDecimal zhichu2 = Common.isEmpty(salaryInfo.getFd_3adfee1ee24680()) ? BigDecimal.ZERO : BigDecimal.valueOf(salaryInfo.getFd_3adfee1ee24680());
				BigDecimal zhichu3 = Common.isEmpty(salaryInfo.getFd_3adfee1f32fa24()) ? BigDecimal.ZERO : BigDecimal.valueOf(salaryInfo.getFd_3adfee1f32fa24());
				BigDecimal zhichu4 = Common.isEmpty(salaryInfo.getFd_3adfee1e2b2f78()) ? BigDecimal.ZERO : BigDecimal.valueOf(salaryInfo.getFd_3adfee1e2b2f78());
				BigDecimal zhichu5 = Common.isEmpty(salaryInfo.getFd_3adfee1374ed7a()) ? BigDecimal.ZERO : BigDecimal.valueOf(salaryInfo.getFd_3adfee1374ed7a());
//				salaryInfo.setFd_3adfeeb34ea0ea(Arrays.stream(numbers).reduce(Double::sum).orElse(0.0));
				salaryInfo.setFd_3adfeeb34ea0ea(BigDecimalUtils.safeAdd(zhichu1,zhichu2,zhichu3,zhichu4,zhichu5).doubleValue());

				//创建时间
				salaryInfo.setCreateTime(DateUtil.getCurrentDateTime());
				salaryInfoList.add(salaryInfo);
			}
			if (!salaryInfoList.isEmpty()) {
				boolean flag = this.saveBatch(salaryInfoList);
				if (flag) {
					//推送成功
					return true;
				}
			}
		}catch (Exception e) {
			log.error("工资明细推送失败:",e);
			return false;
		}
		return false;
	}

	private void copySocialProperties(EkpSalaryParam salaryParam,EkpSalaryInfo salaryInfo) {
		//项目编码
		salaryInfo.setFd_3adfedf98ccba2(salaryParam.getFd_3adfedf98ccba2());
		//项目名称
		salaryInfo.setFd_3adfedf9d2bf1c(salaryParam.getFd_3adfedf9d2bf1c());
		//单号
		salaryInfo.setFd_3adfedfa4410aa(salaryParam.getFd_3adfedfa4410aa());
		//客户编码
		salaryInfo.setFd_3adfedfacd65d6(salaryParam.getFd_3adfedfacd65d6());
		//客户名称
		salaryInfo.setFd_3adfedfb174068(salaryParam.getFd_3adfedfb174068());
		//税务主体
		salaryInfo.setFd_3afab16f356672(salaryParam.getFd_3afab1895feea2());
		//姓名
		salaryInfo.setFd_3adfedfb5a68a2(salaryParam.getFd_3adfedfb5a68a2());
		//身份证号
		salaryInfo.setFd_3adfedfb8f76d4(salaryParam.getFd_3adfedfb8f76d4());
		//手机号
		salaryInfo.setFd_3adfedfbd23ab8(salaryParam.getFd_3adfedfbd23ab8());
		//银行卡号
		salaryInfo.setFd_3adfedfcb17f1e(salaryParam.getFd_3adfedfcb17f1e());
		//开户行
		salaryInfo.setFd_3adfedfc453cc4(salaryParam.getFd_3adfedfc453cc4());
		//暂停发
		salaryInfo.setFd_3af9d5874f8166(salaryParam.getFd_3af9d49d165e90());
		//工资月份
		salaryInfo.setFd_3adfee063acff0(salaryParam.getFd_3adfee063acff0());
		//是否薪资扣税
		salaryInfo.setFd_3adfee01668666(salaryParam.getFd_3adfee01668666());
		//社保优先级
		salaryInfo.setFd_3adfedfed8bb28(salaryParam.getFd_3adfedfed8bb28());
		//公积金优先级
		salaryInfo.setFd_3adfedff3a7430(salaryParam.getFd_3adfedff3a7430());
		//是否自有员工
		salaryInfo.setFd_3adfee0009d070(salaryParam.getFd_3adfee0009d070());
		//年终奖扣税方案
		salaryInfo.setFd_3adfee01dea2fa(salaryParam.getFd_3adfee01dea2fa());
		//工资id
		salaryInfo.setFd_3b10afe8c70742(salaryParam.getFd_3b10af838eab5c());
		//HRO结算月份
		salaryInfo.setFd_3b13b1d1ff9678(salaryParam.getFd_3adfee0690737c());
		//是否为BPO业务
		salaryInfo.setFd_3b178f3e24cc32(salaryParam.getFd_3b178f0ded2114());
		//结算月份
		salaryInfo.setFd_3adfee0690737c(salaryParam.getFd_3adfee0690737c());
		//薪酬申请编号
		salaryInfo.setFd_3b3beee3ec7e12(salaryParam.getFd_3b3bef19b61c38());
		//开户行支行
		salaryInfo.setFd_3b73c214e52982(salaryParam.getFd_3b73de2809465a());
		//初始化导入
		salaryInfo.setFd_3b84d6a6c7b8f0("");
		//发放方式
		salaryInfo.setFd_3bbc0711464020(salaryParam.getFd_3bbbfdd1fc2950());
		//创建人
		salaryInfo.setFd_3c3e5ff65115a2(salaryParam.getFd_3c3e5ff65115a2());
		//应发工资
		salaryInfo.setFd_3adfee12cb8840(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee12cb8840()) ? null : Double.parseDouble(salaryParam.getFd_3adfee12cb8840()));
		//个人代扣
		salaryInfo.setFd_3adfee1374ed7a(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee1374ed7a()) ? null : Double.parseDouble(salaryParam.getFd_3adfee1374ed7a()));
		//单位社保
		salaryInfo.setFd_3adfee1e2b2f78(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee1e2b2f78()) ? null : Double.parseDouble(salaryParam.getFd_3adfee1e2b2f78()));
		//个人社保
		salaryInfo.setFd_3adfee1e88723e(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee1e88723e()) ? null : Double.parseDouble(salaryParam.getFd_3adfee1e88723e()));
		//代扣个人社保
		salaryInfo.setFd_3b16cecc2bbd16(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3b16ce48a9735c()) ? null : Double.parseDouble(salaryParam.getFd_3b16ce48a9735c()));
		//单位公积金
		salaryInfo.setFd_3adfee1ee24680(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee1ee24680()) ? null : Double.parseDouble(salaryParam.getFd_3adfee1ee24680()));
		//个人公积金
		salaryInfo.setFd_3adfee1f32fa24(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee1f32fa24()) ? null : Double.parseDouble(salaryParam.getFd_3adfee1f32fa24()));
		//代扣个人公积金
		salaryInfo.setFd_3b16cecd47a856(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3b16ce4b7fc42a()) ? null : Double.parseDouble(salaryParam.getFd_3b16ce4b7fc42a()));
		//个税
		salaryInfo.setFd_3adfee1f901c46(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee1f901c46()) ? null : Double.parseDouble(salaryParam.getFd_3adfee1f901c46()));
		//企业年金单位
		salaryInfo.setFd_3adfee1ff1ca6a(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee1ff1ca6a()) ? null : Double.parseDouble(salaryParam.getFd_3adfee1ff1ca6a()));
		//企业年金个人
		salaryInfo.setFd_3adfee203f86b2(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee203f86b2()) ? null : Double.parseDouble(salaryParam.getFd_3adfee203f86b2()));
		//实发合计
		salaryInfo.setFd_3adfee20fe5ba4(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee20fe5ba4()) ? null : Double.parseDouble(salaryParam.getFd_3adfee20fe5ba4()));
		//应发工资（导表金额）
		salaryInfo.setFd_3bcdeed22ec8dc(salaryParam.getFd_3bcdee91cacb6c());
		//个人社保（不含代扣）
		salaryInfo.setFd_3bcd3119a295be(salaryParam.getFd_3bcd41d0ae6648());
		//个人公积金（不含代扣）
		salaryInfo.setFd_3bcd311a72d000(salaryParam.getFd_3bcd41d65d5bb2());
		//暂停发金额
		salaryInfo.setFd_3bcd34a8c296c8(salaryParam.getFd_3bcd41de98a582());
		//单位社保（不含代扣）
		salaryInfo.setFd_3bcd3100f45ca2(salaryParam.getFd_3bcd41db081b72());
		//单位公积金（不含代扣）
		salaryInfo.setFd_3bcd3101d95dd8(salaryParam.getFd_3bcd41d1f6f58a());
		//代扣单位公积金
		salaryInfo.setFd_3bcd3102f612ea(salaryParam.getFd_3bcd41d77e4812());
		//个人代扣明细
		salaryInfo.setFd_3bcd2f180f2a8c(salaryParam.getFd_3bcd41dc41cf6a());
		//个人代扣合计
		salaryInfo.setFd_3bcd2f18fd1840(salaryParam.getFd_3bcd41d361534e());
		//代扣单位社保
		salaryInfo.setFd_3bcd2f1a073260(salaryParam.getFd_3bcd41d857b764());
		//免个税个人代扣
		salaryInfo.setFd_3bcd2ef618ee54(salaryParam.getFd_3bcd41dd8b4232());
		//代扣当月个人税
		salaryInfo.setFd_3bcd2ef727ac6a(salaryParam.getFd_3bcd41d453de50());
		//代扣个人年终奖税
		salaryInfo.setFd_3bcd2ef8728fe0(salaryParam.getFd_3bcd41d939aa64());
		//实发工资（银付）
		salaryInfo.setFd_3bcd2e6259fdbe(salaryParam.getFd_3bcd41d550a756());
		//实发工资（现金）
		salaryInfo.setFd_3bcd2e63600446(salaryParam.getFd_3bcd41da212afe());
		//单位待补足
		salaryInfo.setFd_3bcd2e64868de6(salaryParam.getFd_3bcd41dfb9f00e());
		//收入结算状态
		salaryInfo.setFd_3adfee4ba5ad36("未结算");
		//收款状态
		salaryInfo.setFd_3adfee4c0c59ee("未收");
		//代扣费用结算状态
		salaryInfo.setFd_3adfeededfb5a6("未结算");
		//代扣费用付款状态
		salaryInfo.setFd_3adfeed3a20598("未收");
		//个税结算状态
		salaryInfo.setFd_3adfeef8ef38fc("未结算");
		//个税付款状态
		salaryInfo.setFd_3adfeedd08222c("未收");
		//工资实发结算状态
		salaryInfo.setFd_3adfeef9440ab2("未结算");
		//实发合计付款状态
		salaryInfo.setFd_3adfeedd5f3cb2("未收");
		//企业年金单位结算状态
		salaryInfo.setFd_3adfeef9b9fb3e("未结算");
		//企业年金单位付款状态
		salaryInfo.setFd_3adfeeddacf6d4("未收");
		//企业年金个人结算状态
		salaryInfo.setFd_3adfeefa1eba32("未结算");
		//企业年金个人付款状态
		salaryInfo.setFd_3adfeede08d430("未收");
		//个税应支出
		salaryInfo.setFd_3adfeec6db8766(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee1f901c46()) ? null : Double.parseDouble(salaryParam.getFd_3adfee1f901c46()));
		//实发合计应支出
		salaryInfo.setFd_3adfeec730ec44(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee20fe5ba4()) ? null : Double.parseDouble(salaryParam.getFd_3adfee20fe5ba4()));
		//企业年金单位应支出
		salaryInfo.setFd_3adfeec782070a(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee1ff1ca6a()) ? null : Double.parseDouble(salaryParam.getFd_3adfee1ff1ca6a()));
		//企业年金个人应支出
		salaryInfo.setFd_3adfeec7ccdd1c(CommonConstants.EMPTY_STRING.equals(salaryParam.getFd_3adfee203f86b2()) ? null : Double.parseDouble(salaryParam.getFd_3adfee203f86b2()));
		//单号
		salaryInfo.setFd_3adfedfa4410aa("GZ" + LocalDateTimeUtils.formatTime(LocalDateTime.now(),DateUtil.DATE_PATTERN)
				+ "_" + salaryInfo.getFd_3b10afe8c70742());
	}

	@Override
	public R<List<ErrorMessage>> importClaimInfo(InputStream inputStream) {
		List<ErrorMessage> errorMessageList = new ArrayList<>();
		ExcelUtil<ClaimInfotVO> util1 = new ExcelUtil<>(ClaimInfotVO.class);
		// 写法2：
		// 匿名内部类 不用额外写一个DemoDataListener
		// 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
		try {

			EasyExcel.read(inputStream, ClaimInfotVO.class, new ReadListener<ClaimInfotVO>() {
				/**
				 * 单次缓存的数据量
				 */
				public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT1;
				/**
				 *临时存储
				 */
				private List<ClaimInfotVO> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

				@Override
				public void invoke(ClaimInfotVO data, AnalysisContext context) {
					ReadRowHolder readRowHolder = context.readRowHolder();
					Integer rowIndex = readRowHolder.getRowIndex();
					data.setRowIndex(rowIndex + 1);
					ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
					if (Common.isNotNull(errorMessage)) {
						errorMessageList.add(errorMessage);
					} else {
						cachedDataList.add(data);
					}
					if (cachedDataList.size() >= BATCH_COUNT) {
						saveData();
						// 存储完成清理 list
						cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
					}
				}

				@Override
				public void doAfterAllAnalysed(AnalysisContext context) {
					saveData();
				}

				/**
				 * 加上存储数据库
				 */
				private void saveData() {
					log.info("{}条数据，开始存储数据库！", cachedDataList.size());
					importListAdd(cachedDataList, errorMessageList);
					log.info("存储数据库成功！");
				}
			}).sheet().doRead();
		} catch (Exception e) {
			log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR, e);
			return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
		}
		return R.ok(errorMessageList);
	}

	/**
	 * 差额费导入
	 * @param excelVOList
	 * @param errorMessageList
	 * @author huyc
	 * @date 2024-07-04 14:52:16
	 */
	@Transactional
	public void importListAdd(List<ClaimInfotVO> excelVOList, List<ErrorMessage> errorMessageList) {

		ClaimInfotVO excel;
		String deptNo;
		String deptName;
		BigDecimal money;
		ClaimRebackInfotVO info;
		EkpDeptInfoVo deptInfo;
		// 执行数据插入操作 组装 PostDto
		for (int i = 0; i < excelVOList.size(); i++) {
			excel = excelVOList.get(i);
			deptNo = excel.getDeptNo();
			money = excel.getMoney();
			deptName = excel.getDeptName();
			ClaimRebackInfotVO backInfo = new ClaimRebackInfotVO();

			//根据项目编码获取ekp所有项目信息
			if (money.compareTo(BigDecimal.ZERO) >= 0) {
				//先找到彭超创建的款项认领明细
				info = baseMapper.getClaimInfoByDeptNo(deptNo,"1");
				//调整金额大于零的先找到彭超创建的款项认领明细直接加
				if (Optional.ofNullable(info).isPresent()) {
					info.setAdjustMoney(money);
					info.setAfterAdjustMoney(BigDecimalUtils.safeAdd(info.getSurMoney(),money));
					errorMessageList.add(new ErrorMessage(excel.getRowIndex(), info.getErrorInfo(),info));
				} else {
					//找到除了彭超之外的最早的一条款项认领明细
					info = baseMapper.getClaimInfoByDeptNo(deptNo,"2");
					if (Optional.ofNullable(info).isPresent()) {
						info.setAdjustMoney(money);
						info.setAfterAdjustMoney(BigDecimalUtils.safeAdd(info.getSurMoney(),money));
						errorMessageList.add(new ErrorMessage(excel.getRowIndex(), info.getErrorInfo(),info));
					} else {
						backInfo.setDeptName(deptName);
						backInfo.setDeptNo(deptNo);
						backInfo.setAdjustMoney(money);
						backInfo.setErrorInfo("未找到该项目对应的款项认领明细");
						errorMessageList.add(new ErrorMessage(excel.getRowIndex(), backInfo.getErrorInfo(),backInfo));
					}
				}
			} else {
				//调整金额小于零的先找到剩余金额大于零的彭超创建的款项认领明细去扣减
				info = baseMapper.getClaimInfoByDeptNo(deptNo,"3");
				if (Optional.ofNullable(info).isPresent()) {
					if (info.getSurMoney().add(money).compareTo(BigDecimal.ZERO) >=0) {
						info.setAdjustMoney(money);
						info.setAfterAdjustMoney(BigDecimalUtils.safeAdd(info.getSurMoney(),money));
						errorMessageList.add(new ErrorMessage(excel.getRowIndex(), info.getErrorInfo(),info));
					} else {
						info.setAdjustMoney(info.getSurMoney().negate());
						info.setAfterAdjustMoney(BigDecimal.ZERO);
						money = info.getSurMoney().add(money);
						errorMessageList.add(new ErrorMessage(excel.getRowIndex(), info.getErrorInfo(),info));
						this.subSwitch(deptNo,backInfo,errorMessageList,money,info.getDeptName(),excel,"2");
					}
				} else {
					this.subSwitch(deptNo,backInfo,errorMessageList,money,deptName,excel,"1");
				}
			}
		}
	}

	public void subSwitch(String deptNo,ClaimRebackInfotVO backInfo,List<ErrorMessage>errorMessageList,
								BigDecimal money,String deptName,ClaimInfotVO excel,String flag) {
		List<ClaimRebackInfotVO> infoList = baseMapper.getClaimBigInfoByDeptNoAndUser(deptNo);
		if (Common.isNotNull(infoList)) {
			for (ClaimRebackInfotVO subInfo : infoList) {
				//分批去减去金额
				if (subInfo.getSurMoney().add(money).compareTo(BigDecimal.ZERO) >=0) {
					subInfo.setAdjustMoney(money);
					subInfo.setAfterAdjustMoney(BigDecimalUtils.safeAdd(subInfo.getSurMoney(),money));
					money = BigDecimal.ZERO;
					errorMessageList.add(new ErrorMessage(excel.getRowIndex(), subInfo.getErrorInfo(),subInfo));
					break;
				} else {
					subInfo.setAdjustMoney(subInfo.getSurMoney().negate());
					subInfo.setAfterAdjustMoney(BigDecimal.ZERO);
					money = subInfo.getSurMoney().add(money);
					deptName = subInfo.getDeptName();
					errorMessageList.add(new ErrorMessage(excel.getRowIndex(), subInfo.getErrorInfo(),subInfo));
				}
			}
		} else {
			if ("1".equals(flag)) {
				backInfo.setDeptName(deptName);
				backInfo.setDeptNo(deptNo);
				backInfo.setAdjustMoney(money);
				backInfo.setErrorInfo("未找到该项目对应的款项认领明细");
				errorMessageList.add(new ErrorMessage(excel.getRowIndex(), backInfo.getErrorInfo(), backInfo));
				return;
			}
		}
		if (BigDecimal.ZERO.compareTo(money) > 0 ) {
			backInfo.setDeptNo(deptNo);
			backInfo.setDeptName(deptName);
			backInfo.setAdjustMoney(money);
			backInfo.setErrorInfo("剩余仍需扣除金额:" + money.toString());
			errorMessageList.add(new ErrorMessage(excel.getRowIndex(), backInfo.getErrorInfo(),backInfo));
		}
	}
}
