package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author licancan
 * @description 商险替换表 t_insurance_replace
 * @date 2022-07-20 14:20:16
 */
@Data
@TableName("t_insurance_replace")
@Schema(description = "商险替换表")
public class TInsuranceReplace implements Serializable {
	private static final long serialVersionUID = -8528017421473755436L;

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 被替换人明细id
     */
	@Schema(description = "被替换人明细id")
    private String fromInsuranceDetailId;

    /**
     * 替换人明细ID
     */
	@Schema(description = "替换人明细ID")
    private String toInsuranceDetailId;

    /**
     * 原始明细id
     */
	@Schema(description = "原始明细id")
    private String originInsuranceDetailId;

    /**
     * 0失败 1成功
     */
	@Schema(description = "0失败 1成功")
    private Integer replaceStatus;

    /**
     * 替换成功时间
     */
	@Schema(description = "替换成功时间")
    private LocalDateTime replaceTime;

    /**
     * 创建人
     */
	@Schema(description = "创建人")
    private String createBy;

    /**
     * 创建人姓名
     */
	@Schema(description = "创建人-姓名")
    private String createName;

    /**
     * 创建时间
     */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;

}