package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author zhaji
 * @description 商险附件查询返回类
 * @date 2022-08-23 10:37:30
 */
@Data
@Tag(name = "商险附件查询返回类")
public class InsuranceEnclosureVo implements Serializable {

	/**
	 *
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 附件名
	 */
	@Schema(description = "附件名")
	private String enclosureName;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
	private String remark;

	/**
	 * 创建者-姓名
	 */
	@Schema(description = "创建人-姓名")
	private String createName;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	private LocalDateTime createTime;

}
