package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * 审批配置表
 *
 * @author wangan
 * @date 2020-12-07 14:08:38
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_process_approval_conf")
@Schema(description = "审批配置表")
public class TProcessApprovalConf extends Model<TProcessApprovalConf> {
    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    @NotBlank(message = "字段名称不能为空")
    @Length(max = 32, message = "字段名称不能超过32个字符")
	@Schema(description = "字段名称")
    private String fieldName;

    @NotBlank(message = "字段值不能为空")
    @Length(max = 32, message = "字段值不能超过32个字符")
	@Schema(description = "字段值")
    private String fieldValue;

    @NotBlank(message = "类名不能为空")
    @Length(max = 32, message = "类名不能超过32个字符")
	@Schema(description = "类名")
    private String className;

    @Length(max = 32, message = "主流程id不能超过32个字符")
	@Schema(description = "主流程id")
    private String processId;

    @NotBlank(message = "父配置id不能为空")
    @Length(max = 32, message = "父配置id不能超过32个字符")
	@Schema(description = "父配置id")
    private String parentId;

    @NotBlank(message = "类型不能为空")
    @Length(max = 1, message = "类型不能超过1个字符")
	@Schema(description = "类型  1不购买商险申请")
    private String type;

    @Length(max = 1, message = "删除表示 0未删除 1删除不能超过1个字符")
	@Schema(description = "删除表示 0未删除 1删除")
    private String deleteFlag;

    @Length(max = 100, message = "备注不能超过100个字符")
	@Schema(description = "备注")
    private String remark;
}
