package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.social.entity.FailReasonConfig;
import com.yifu.cloud.plus.v1.yifu.social.service.FailReasonConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.Optional;

/**
 * 失败原因配置
 *
 * @author huyc
 * @date 2024-05-08 10:41:32
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/failreasonconfig" )
@Tag(name = "失败原因配置管理")
public class FailReasonConfigController {

	private final  FailReasonConfigService failReasonConfigService;

	/**
	 * 简单分页查询
	 * @param page 分页对象
	 * @param failReasonConfig 失败原因配置
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<FailReasonConfig>> getFailReasonConfigPage(Page<FailReasonConfig> page, FailReasonConfig failReasonConfig) {
		return  new R<>(failReasonConfigService.getFailReasonConfigPage(page,failReasonConfig));
	}

	/**
	 * 通过id查询失败原因配置
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}" )
	public R<FailReasonConfig> getById(@PathVariable("id" ) String id) {
		return R.ok(failReasonConfigService.getById(id));
	}

	/**
	 * 新增失败原因配置
	 * @param failReasonConfig 失败原因配置
	 * @return R
	 */
	@Operation(summary = "新增失败原因配置", description = "新增失败原因配置")
	@SysLog("新增失败原因配置" )
	@PostMapping
	public R<Boolean> save(@RequestBody FailReasonConfig failReasonConfig) {
		FailReasonConfig failReasonCount = failReasonConfigService.getOne(Wrappers.<FailReasonConfig>query().lambda()
				.eq(FailReasonConfig::getReasonKey,failReasonConfig.getReasonKey())
				.last(CommonConstants.LAST_ONE_SQL));
		if(Optional.ofNullable(failReasonCount).isPresent()) {
			return R.failed("已存在对应的关键字的失败原因配置！");
		}
		YifuUser user = SecurityUtils.getUser();
		if (Common.isNotNull(user)) {
			failReasonConfig.setUpdateName(user.getNickname());
		}
		return R.ok(failReasonConfigService.save(failReasonConfig));
	}

	/**
	 * 修改失败原因配置
	 * @param failReasonConfig 失败原因配置
	 * @return R
	 */
	@Operation(summary = "修改失败原因配置", description = "修改失败原因配置)")
	@SysLog("修改失败原因配置" )
	@PutMapping
	public R<Boolean> updateById(@RequestBody FailReasonConfig failReasonConfig) {
		FailReasonConfig failReasonCount = failReasonConfigService.getOne(Wrappers.<FailReasonConfig>query().lambda()
				.eq(FailReasonConfig::getReasonKey,failReasonConfig.getReasonKey())
				.ne(FailReasonConfig::getId,failReasonConfig.getId())
				.last(CommonConstants.LAST_ONE_SQL));
		if(Optional.ofNullable(failReasonCount).isPresent()) {
			return R.failed("已存在对应的关键字的失败原因配置！");
		}
		YifuUser user = SecurityUtils.getUser();
		if (Common.isNotNull(user)) {
			failReasonConfig.setUpdateName(user.getNickname());
		}
		return R.ok(failReasonConfigService.updateById(failReasonConfig));
	}

	/**
	 * 通过id删除失败原因配置
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除失败原因配置", description = "通过id删除失败原因配置")
	@SysLog("通过id删除失败原因配置" )
	@DeleteMapping("/{id}" )
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(failReasonConfigService.removeById(id));
	}

}