/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchExportLog;
import com.yifu.cloud.plus.v1.yifu.social.service.TDispatchExportLogService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 社保导出花名册记录表
 *
 * @author hgw
 * @date 2025-06-16 14:29:13
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tdispatchexportlog")
@Tag(name = "社保导出花名册记录表管理")
public class TDispatchExportLogController {

	private final TDispatchExportLogService tDispatchExportLogService;


	/**
	 * 简单分页查询
	 *
	 * @param page               分页对象
	 * @param tDispatchExportLog 社保导出花名册记录表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TDispatchExportLog>> getTDispatchExportLogPage(Page<TDispatchExportLog> page, TDispatchExportLog tDispatchExportLog) {
		IPage<TDispatchExportLog> pageList = tDispatchExportLogService.getTDispatchExportLogPage(page, tDispatchExportLog);
		if (pageList != null) {
			List<TDispatchExportLog> logList = pageList.getRecords();
			if (!logList.isEmpty() && Common.isNotNull(page.getCurrent()) && Common.isNotNull(page.getSize())) {
				for (int i = 0; i < logList.size(); i++) {
					logList.get(i).setNumber((page.getCurrent() - 1) * page.getSize() + i + 1);
				}
			}
		}
		return new R<>(pageList);
	}
}
