/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.admin.api.vo;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDictItem;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutEmpFormInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 瓜子采集字段配置表（前端用配置进行展示）
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@Data
public class SysOutEmpFormInfoVo extends SysOutEmpFormInfo {

	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,多个逗号分割")
	private String ids;

	@Schema(description = "分类名称")
	private String categorizeName;

	@Schema(description = "字典项列表")
	private List<SysDictItem> dictItemList;

	@Schema(description = "瓜子和皖信的字典值映射")
	private List<Map<String,String>> relDictMapList;

	@Schema(description = "瓜子字典项字符串")
	private String dictItemStrs;

	@Schema(description = "映射皖信的字典项字符串")
	private String wxDictItemStrs;

}
