/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzOfferInfo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzOfferInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 瓜子offer信息接收表
 *
 * @author chenyx
 * @date 2025-06-11 15:58:37
 */
public interface TGzOfferInfoService extends IService<TGzOfferInfo> {
	/**
	 * 瓜子offer信息接收表简单分页查询
	 *
	 * @param tGzOfferInfo 瓜子offer信息接收表
	 * @return
	 */
	IPage<TGzOfferInfoVo> getTGzOfferInfoPage(Page<TGzOfferInfoVo> page, TGzOfferInfoVo tGzOfferInfo);

	/**
	 * 仅返回指定条数的列表数据
	 * @param tGzOfferInfo 瓜子offer信息接收表
	 * @return R<List<TGzOfferInfoVo>>
	 */
	List<TGzOfferInfoVo> getTGzOfferInfoList(TGzOfferInfoVo tGzOfferInfo);


	/**
	 * 符合查询条件的数量
	 * @param tGzOfferInfo 瓜子offer信息接收表
	 * @return R<Integer>
	 */
	Integer getTGzOfferInfoCount(TGzOfferInfoVo tGzOfferInfo);


	TGzOfferInfo getDataById(Integer id);

	/**
	 * 修改瓜子offer信息
	 *
	 * @param tGzOfferInfo 字典
	 * @return R<String>
	 */
	R<String> updateDataById(TGzOfferInfo tGzOfferInfo);

	/**
	 * 瓜子offer手动状态更新
	 *
	 * @param tGzOfferInfo 字典
	 * @return R<String>
	 */
	R<String> updateStatus(TGzOfferInfo tGzOfferInfo);

	/**
	 * 瓜子候选人信息审核
	 * @param tGzOfferInfo 字典
	 * @return R<String>
	 */
	R<String> offerAudit(TGzOfferInfo tGzOfferInfo);



	/**
	 * @Description: 批量导入
	 * @Author: hgw
	 * @Date: 2025/6/17 9:32
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> importDiy(InputStream inputStream);

	R<String> sendOfferAlert(TGzOfferInfoVo tGzOfferInfo);

	R<String> sendCollectOfferMsg(TGzOfferInfoVo tGzOfferInfo);

	R<String> sendContractDownloadOfferMsg(TGzOfferInfoVo tGzOfferInfo);

	/**
	 * @Description: 导出列表
	 * @Author: hgw
	 * @Date: 2025/6/17 9:33
	 * @return: void
	 **/
	void exportMain(HttpServletResponse response, TGzOfferInfoVo searchVo);

	/**
	 * @Description: 导出详情
	 * @Author: hgw
	 * @Date: 2025/6/17 9:33
	 * @return: void
	 **/
	void exportDetail(HttpServletResponse response, TGzOfferInfoVo searchVo);

	/**
	 * 瓜子批量更新offer状态
	 * @param tGzOfferInfo 瓜子offer信息接收表
	 * @return R
	 */
	R batchUpdateStatus(TGzOfferInfoVo tGzOfferInfo);


}
