package com.yifu.cloud.plus.v1.business.entity.salary;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * B端-原表表头与配置关联表
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_salary_config_title_res")
@Schema(description = "B端-原表表头与配置关联表")
public class TBusSalaryConfigTitleRes extends Model<TBusSalaryConfigTitleRes> {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;
     /**
      * 结算主体id
      */
     @NotBlank(message = "结算主体id不能为空")
     @Length(max = 32, message = "结算主体id不能超过32个字符")
     @ExcelAttribute(name = "结算主体id", isNotEmpty = true, errorInfo = "结算主体id不能为空", maxLength = 32)
     @Schema(description = "结算主体id")
     private Integer deptId;
     /**
      * 结算主体Name
      */
     @Length(max = 32, message = "结算主体Name不能超过32个字符")
     @ExcelAttribute(name = "结算主体Name", maxLength = 32)
     @Schema(description = "结算主体Name")
     private String deptName;
     /**
      * 结算主体No
      */
     @Length(max = 32, message = "结算主体No不能超过32个字符")
     @ExcelAttribute(name = "结算主体No", maxLength = 32)
     @Schema(description = "结算主体No")
     private String deptNo;
     /**
      * 原表表头
      */
     @NotBlank(message = "原表表头不能为空")
     @Length(max = 50, message = "原表表头不能超过50个字符")
     @ExcelAttribute(name = "原表表头", isNotEmpty = true, errorInfo = "原表表头不能为空", maxLength = 50)
     @Schema(description = "原表表头")
     private String excelTitle;
     /**
      * 配置id
      */
     @NotBlank(message = "配置id不能为空")
     @Length(max = 32, message = "配置id不能超过32个字符")
     @ExcelAttribute(name = "配置id", isNotEmpty = true, errorInfo = "配置id不能为空", maxLength = 32)
     @Schema(description = "配置id")
     private String configId;
     /**
      * 配置名称
      */
     @Length(max = 32, message = "配置名称不能超过32个字符")
     @ExcelAttribute(name = "配置名称", maxLength = 32)
     @Schema(description = "配置名称")
     private String configName;
     /**
      * 创建人id
      */
     @Length(max = 32, message = "创建人id不能超过32个字符")
     @ExcelAttribute(name = "创建人id", maxLength = 32)
     @Schema(description = "创建人id")
     private String createUserId;
     /**
      * 创建人姓名
      */
     @Length(max = 50, message = "创建人姓名不能超过50个字符")
     @ExcelAttribute(name = "创建人姓名", maxLength = 50)
     @Schema(description = "创建人姓名")
     private String createUserName;
     /**
      * 创建时间
      */
     @ExcelAttribute(name = "创建时间")
     @Schema(description = "创建时间")
     private LocalDateTime createTime;
     /**
      * 保存类型：0:保存；1不保存
      */
     @ExcelAttribute(name = "保存类型：0:保存；1不保存")
     @Schema(description = "保存类型：0:保存；1不保存")
     private Integer saveType;
}
