package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.yifu.cloud.plus.v1.check.entity.TCheckIdCard;
import com.yifu.cloud.plus.v1.check.entity.TCheckMobile;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprCheckProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * @Author fxj
 * @Date 2022/7/11
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprCheckProperties.class)
public class CheckDaprUtil {
	@Autowired
	private DaprCheckProperties daprCheckProperties;
	/**
	 * @Author fxj
	 * @Description  身份证&姓名一致性校验
	 * @Date 21:15 2022/7/18
	 * @Param
	 * @return
	**/
	public R<TCheckIdCard> 	checkIdCardSingle(TCheckIdCard tCheckIdCard){
		R<TCheckIdCard> res = HttpDaprUtil.invokeMethodPost(daprCheckProperties.getAppUrl(),daprCheckProperties.getAppId(),"/tcheckidcard/inner/checkIdCardSingle",JSON.toJSONString(tCheckIdCard), TCheckIdCard.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("校验身份证信息失败！");
		}
		return res;
	}

	public R<Boolean>  checkIdCardAndMobile(String empName, String idCard, String mobile){
		if (Common.isNotNull(empName) && Common.isNotNull(idCard)){
			TCheckIdCard tCheckIdCard = new TCheckIdCard();
			tCheckIdCard.setIdCard(idCard);
			tCheckIdCard.setName(empName);
			R<TCheckIdCard> res = HttpDaprUtil.invokeMethodPost(daprCheckProperties.getAppUrl(),daprCheckProperties.getAppId(),"/tcheckidcard/inner/checkIdCardSingle",JSON.toJSONString(tCheckIdCard), TCheckIdCard.class, SecurityConstants.FROM_IN);
			if (Common.isEmpty(res) || Common.isEmpty(res.getData())){
				return R.failed("校验身份证信息失败！");
			}
			TCheckIdCard checkIdCard = res.getData();
			if (Common.isEmpty(checkIdCard.getIsTrue()) || CommonConstants.ZERO_INT == checkIdCard.getIsTrue().intValue()){
				return R.failed(checkIdCard.getReason());
			}
		}

		if (Common.isNotNull(mobile)){
			TCheckMobile checkMobile = new TCheckMobile();
			checkMobile.setMobile(mobile);
			R<TCheckMobile> res = HttpDaprUtil.invokeMethodPost(daprCheckProperties.getAppUrl(),daprCheckProperties.getAppId(),"/tcheckmobile/inner/checkOneMobile",JSON.toJSONString(checkMobile), TCheckMobile.class, SecurityConstants.FROM_IN);
			if (Common.isEmpty(res) || Common.isEmpty(res.getData())){
				return R.failed("校验手机号码信息失败！");
			}
			TCheckMobile cm = res.getData();
			if (Common.isEmpty(cm.getStatus()) || !CommonConstants.ONE_STRING.equals(cm.getStatus())){
				return R.failed(cm.getMessage());
			}

		}
		return R.ok();
	}

}
