package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @author huyc
 * @description 商险办理批增入参
 * @date 2025-04-3 08:43:31
 */
@Data
@Schema(description = "商险办理单个/批量批增入参")
public class InsuranceAutoParam implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 项目id
	 */
	@Schema(description = "项目id")
	private String deptId;
	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 岗位
	 */
	@Schema(description = "岗位")
	private String post;

	/**
	 * 保单号
	 */
	@Schema(description = "保单号")
	private String policyNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 商险购买地省名称
	 */
	@Schema(description = "商险购买地省名称")
	private String insuranceProvinceName;

	/**
	 * 商险购买地市名称
	 */
	@Schema(description = "商险购买地市名称")
	private String insuranceCityName;

	/**
	 * 商险办理省名称
	 */
	@Schema(description = "商险办理省名称")
	private String insuranceHandleProvinceName;

	/**
	 * 商险办理城市名称
	 */
	@Schema(description = "商险办理城市名称")
	private String insuranceHandleCityName;

	/**
	 * 结算月
	 */
	@Schema(description = "结算月")
	private String settleMonth;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
	private String remark;

	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;

	/**
	 * 结算类型 (1、单独结算 2、合并结算-和工资一起结算)
	 */
	@Schema(description = "结算类型")
	private Integer settleType;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private String policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private String policyEnd;

	/**
	 * 替换员工姓名
	 */
	@Schema(description = "替换员工姓名")
	private String replaceEmpName;

	/**
	 * 替换员工身份证号
	 */
	@Schema(description = "替换员工身份证号")
	private String replaceEmpIdcardNo;

	/**
	 * 替换员工项目编码
	 */
	@Schema(description = "替换员工项目编码")
	private String replaceDeptNo;

	/**
	 * 商险待购买id
	 */
	@Schema(description = "商险待购买id")
	private String insurancePreId;

	/**
	 * 前端客服姓名
	 */
	@Schema(description = "前端客服姓名")
	private String customerUserName;
}
