/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardIssue;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardIssueSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 薪资代发户配置
 *
 * @author hgw
 * @date 2023-01-10 11:34:27
 */
public interface TSalaryStandardIssueService extends IService<TSalaryStandardIssue> {
	/**
	 * 薪资代发户配置简单分页查询
	 *
	 * @param tSalaryStandardIssue 薪资代发户配置
	 * @return
	 */
	IPage<TSalaryStandardIssue> getTSalaryStandardIssuePage(Page<TSalaryStandardIssue> page, TSalaryStandardIssueSearchVo tSalaryStandardIssue);

	void listExport(HttpServletResponse response, TSalaryStandardIssueSearchVo searchVo);

	List<TSalaryStandardIssue> noPageDiy(TSalaryStandardIssueSearchVo searchVo);
}
