/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAutoPaymentDetail;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAutoPaymentInfo;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TAutoPaymentInfoMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TAutoPaymentInfoService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TAutoPaymentDetailVo;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TAutoPaymentDetailMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TAutoPaymentDetailService;
import lombok.AllArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.vo.TAutoPaymentDetailSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.io.InputStream;
import java.util.List;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;

import javax.servlet.ServletOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;

/**
 * 自动化实缴记录表
 *
 * @author fxj
 * @date 2024-05-24 10:56:42
 */
@Log4j2
@AllArgsConstructor
@Service
public class TAutoPaymentDetailServiceImpl extends ServiceImpl<TAutoPaymentDetailMapper, TAutoPaymentDetail> implements TAutoPaymentDetailService {
	@Autowired
	private RedisUtil redisUtil;

	private final TAutoPaymentInfoMapper paymentInfoMapper;
	/**
	 * 自动化实缴记录表简单分页查询
	 *
	 * @param tAutoPaymentDetail 自动化实缴记录表
	 * @return
	 */
	@Override
	public IPage<TAutoPaymentDetail> getTAutoPaymentDetailPage(Page<TAutoPaymentDetail> page, TAutoPaymentDetailSearchVo tAutoPaymentDetail) {
		return baseMapper.getTAutoPaymentDetailPage(page, tAutoPaymentDetail);
	}

	/**
	 * 自动化实缴记录表批量导出
	 *
	 * @param searchVo 自动化实缴记录表
	 * @return
	 */
	@Override
	public void listExport(HttpServletResponse response, TAutoPaymentDetailSearchVo searchVo) {
		String fileName = "自动化实缴记录表批量导出" + DateUtil.getThisTime() + ".xlsx";
		//获取要导出的列表
		List<TAutoPaymentDetail> list = new ArrayList<>();
		long count = noPageCountDiy(searchVo);
		ServletOutputStream out = null;
		YifuUser user = SecurityUtils.getUser();
		String key = CacheConstants.PAYMENT_SOCIAL_EXPORT + CommonConstants.DOWN_LINE_STRING +user.getId() ;
		try {
			out = response.getOutputStream();
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, CommonConstants.UTF8));
			if (Common.isNotNull(redisUtil.get(key))) {
				out.write(CommonConstants.SOCIAL_EXPORT_CONTINUE.getBytes("GBK"));
				out.close();
				return;
			} else {
				redisUtil.set(key, user.getId(), 600L);
			}
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, TAutoPaymentDetail.class).build();
			WriteSheet writeSheet;
			int index = 0;
			if (count > CommonConstants.ZERO_INT) {
				for (int i = 0; i <= count; ) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = noPageDiy(searchVo);
					if (Common.isNotNull(list)) {
						ExcelUtil<TAutoPaymentDetail> util = new ExcelUtil<>(TAutoPaymentDetail.class);
						for (TAutoPaymentDetail vo : list) {
							util.convertEntity(vo, null, null, null);
						}
						writeSheet = EasyExcel.writerSheet("自动化实缴记录表" + index).build();
						excelWriter.write(list, writeSheet);
						index++;
					}
					i = i + CommonConstants.EXCEL_EXPORT_LIMIT;
					if (Common.isNotNull(list)) {
						list.clear();
					}
				}
			} else {
				writeSheet = EasyExcel.writerSheet("自动化实缴记录表" + index).build();
				excelWriter.write(list, writeSheet);
			}
			if (Common.isNotNull(list)) {
				list.clear();
			}
			out.flush();
			excelWriter.finish();
		} catch (Exception e) {
			redisUtil.remove(key);
			log.error("执行异常", e);
		} finally {
			try {
				if (null != out) {
					out.close();
				}
				redisUtil.remove(key);
			} catch (IOException e) {
				redisUtil.remove(key);
				log.error("执行异常", e);
			}
		}
	}

	@Override
	public List<TAutoPaymentDetail> noPageDiy(TAutoPaymentDetailSearchVo searchVo) {
		LambdaQueryWrapper<TAutoPaymentDetail> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TAutoPaymentDetail::getId, idList);
		}
		if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0) {
			wrapper.last(" limit " + searchVo.getLimitStart() + "," + searchVo.getLimitEnd());
		}
		wrapper.orderByAsc(TAutoPaymentDetail::getSourceType);
		wrapper.orderByAsc(BaseEntity::getCreateTime);
		return baseMapper.selectList(wrapper);
	}

	@Override
	public void deleteByParentId(String parentId, int sourceType) {
		baseMapper.deleteByParentId(parentId, sourceType);
	}
	@Override
	public List<TAutoPaymentDetail> getListByParentId(String parentId) {
		return baseMapper.getListByParentId(parentId);
	}
	@Override
	public int getCountByParentId(String parentId) {
		return baseMapper.getCountByParentId(parentId);
	}

	private Long noPageCountDiy(TAutoPaymentDetailSearchVo searchVo) {
		LambdaQueryWrapper<TAutoPaymentDetail> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TAutoPaymentDetail::getId, idList);
		}
		return baseMapper.selectCount(wrapper);
	}

	private LambdaQueryWrapper buildQueryWrapper(TAutoPaymentDetailSearchVo entity) {
		LambdaQueryWrapper<TAutoPaymentDetail> wrapper = Wrappers.lambdaQuery();
		if (ArrayUtil.isNotEmpty(entity.getCreateTimes())) {
			wrapper.ge(TAutoPaymentDetail::getCreateTime, entity.getCreateTimes()[0])
					.le(TAutoPaymentDetail::getCreateTime,
							entity.getCreateTimes()[1]);
		}
		if (Common.isNotNull(entity.getCreateName())) {
			wrapper.eq(TAutoPaymentDetail::getCreateName, entity.getCreateName());
		}
		return wrapper;
	}

	@Override
	public R<List<ErrorMessage>> importDiy(InputStream inputStream,String parentId) {
		List<ErrorMessage> errorMessageList = new ArrayList<>();
		ExcelUtil<TAutoPaymentDetailVo> util1 = new ExcelUtil<>(TAutoPaymentDetailVo.class);
		// 写法2：
		// 匿名内部类 不用额外写一个DemoDataListener
		// 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
		try {
			EasyExcel.read(inputStream, TAutoPaymentDetailVo.class, new ReadListener<TAutoPaymentDetailVo>() {
				/**
				 * 单次缓存的数据量
				 */
				public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT;
				/**
				 *临时存储
				 */
				private List<TAutoPaymentDetailVo> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

				@Override
				public void invoke(TAutoPaymentDetailVo data, AnalysisContext context) {
					ReadRowHolder readRowHolder = context.readRowHolder();
					Integer rowIndex = readRowHolder.getRowIndex();
					data.setRowIndex(rowIndex + 1);
					ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
					if (Common.isNotNull(errorMessage)) {
						errorMessage.setData(data);
						errorMessageList.add(errorMessage);
					} else {
						cachedDataList.add(data);
					}
					if (cachedDataList.size() >= BATCH_COUNT) {
						saveData();
						// 存储完成清理 list
						cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
					}
				}

				@Override
				public void doAfterAllAnalysed(AnalysisContext context) {
					saveData();
				}

				/**
				 * 加上存储数据库
				 */
				private void saveData() {
					log.info("{}条数据，开始存储数据库！", cachedDataList.size());
					importTAutoPaymentDetail(cachedDataList, errorMessageList,parentId);
					log.info("存储数据库成功！");
				}
			}).sheet().doRead();
		} catch (Exception e) {
			log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR, e);
			return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
		}
		return judgeAllMessage(errorMessageList);
	}
	/**
	 * @Author fxj
	 * @Description 判断所有返回数据，是否全部为正确的
	 * @Date 18:01 2023/10/18
	 * @Param
	 * @return
	 **/
	private R<List<ErrorMessage>> judgeAllMessage(List<ErrorMessage> errorMessageList) {
		if (!errorMessageList.isEmpty() && errorMessageList.stream().noneMatch(e-> e.getColor().equals(CommonConstants.RED))) {
			return R.ok();
		}
		return R.ok(errorMessageList);
	}
	private void importTAutoPaymentDetail(List<TAutoPaymentDetailVo> excelVOList, List<ErrorMessage> errorMessageList,String parentId) {
		// 执行数据插入操作 组装
		TAutoPaymentDetailVo excel;
		List<TAutoPaymentDetail> details = null;
		List<TAutoPaymentDetail> updateList =null;
		TAutoPaymentInfo paymentInfo = paymentInfoMapper.selectById(parentId);
		for (int i = 0; i < excelVOList.size(); i++) {
			excel = excelVOList.get(i);
			if (Common.isEmpty(paymentInfo)){
				errorMessageList.add(new ErrorMessage(excel.getRowIndex(), CommonConstants.PARAM_IS_NOT_ERROR,excel));
				continue;
			}
			if (CommonConstants.ONE_STRING.equals(paymentInfo.getRepeatReviewFlag())){
				errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "重新复核中,禁止更新！",excel));
				continue;
			}
			// 数据合法情况
			if (!CommonConstants.ZERO_STRING.equals(excel.getRepeatHandleFlag()) && !CommonConstants.ONE_STRING.equals(excel.getRepeatHandleFlag())){
				errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "'是否重新办理'填写不正确！",excel));
				continue;
			}
			details = baseMapper.selectList(Wrappers.<TAutoPaymentDetail>query().lambda()
					.eq(TAutoPaymentDetail::getParentId,parentId)
					.eq(TAutoPaymentDetail::getEmpName,excel.getEmpName())
					.eq(TAutoPaymentDetail::getCertNum,excel.getCertNum())
					.eq(TAutoPaymentDetail::getSocialSecurityAccount,excel.getSocialSecurityAccount()));
			if (Common.isEmpty(details)){
				errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "对应姓名+证件号码+社保户的数据不存在！",excel));
				continue;
			}
			if (Common.isNotNull(details)){
				updateList = new ArrayList<>();
				for (TAutoPaymentDetail detail:details){
					if (detail.getRepeatHandleFlag().equals(excel.getRepeatHandleFlag())){
						continue;
					}
					detail.setRepeatHandleFlag(excel.getRepeatHandleFlag());
					updateList.add(detail);
				}
				if (Common.isNotNull(updateList)){
					// 插入
					this.updateBatchById(updateList);
				}
			}
			errorMessageList.add(new ErrorMessage(excel.getRowIndex(), CommonConstants.SAVE_SUCCESS,CommonConstants.GREEN,excel));
			//清空数据
			if (Common.isNotNull(updateList)){
				updateList.clear();
			}
			if (Common.isNotNull(details)){
				details.clear();
			}
		}
	}

}
