/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutEmpFormInfo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysOutEmpCategorizeFormInfoVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysOutEmpFormInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * 瓜子采集字段配置表（前端用配置进行展示）
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
public interface SysOutEmpFormInfoService extends IService<SysOutEmpFormInfo> {

	/**
	 * 瓜子C端采集配置列表
	 * @return List<SysOutEmpCategorizeFormInfoVo>
	 */
	List<SysOutEmpCategorizeFormInfoVo> getConfigList(String isLookToc);

    /**
     * 瓜子&HRO映射关系表-分页查询
     * @param sysOutEmpFormInfo 查询信息
     * @return IPage<SysOutEmpFormInfoVo>
     */
    IPage<SysOutEmpFormInfoVo> getSysOutEmpFormInfoPage(Page<SysOutEmpFormInfo> page, SysOutEmpFormInfoVo sysOutEmpFormInfo);

    List<SysOutEmpFormInfoVo> noPageDiy(SysOutEmpFormInfoVo sysOutEmpFormInfo);

	/**
	 * 瓜子&HRO映射关系表-下拉列表
	 * @return List<SysOutEmpFormInfo>
	 */
	List<SysOutEmpFormInfo> getSysOutEmpFormSelect();


	/**
	 * 通过id查询瓜子采集字段配置
	 * @param id 主键
	 * @return SysOutEmpFormInfoVo
	 */
	SysOutEmpFormInfoVo getDataById(String id);

	/**
	 * 通过id查询瓜子和皖信映射关系配置详情
	 * @param id 主键
	 * @return SysOutEmpFormInfoVo
	 */
	SysOutEmpFormInfoVo getRelWxDataById(String id);

	/**
	 * 修改瓜子采集字段配置
	 * @param sysOutEmpFormInfo 字典
	 * @return R<String>
	 */
	R<String> updateOutEmpFormInfo(SysOutEmpFormInfo sysOutEmpFormInfo);


}
