/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 法大大专业版模版表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
@Data
@TableName("t_fasc_template")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大专业版模版表")
public class TFascTemplate extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 公司主体Id
	 */
	@ExcelAttribute(name = "公司主体Id", maxLength = 100)
	@Length(max = 100, message = "公司主体Id不能超过100个字符")
	@ExcelProperty("公司主体Id")
	@Schema(description = "公司主体Id")
	private String companyId;
	/**
	 * 公司主体
	 */
	@ExcelAttribute(name = "公司主体", maxLength = 100)
	@Length(max = 100, message = "公司主体不能超过100个字符")
	@ExcelProperty("公司主体")
	@Schema(description = "公司主体")
	private String companyName;
	/**
	 * 签署方
	 */
	@ExcelAttribute(name = "签署方", maxLength = 100)
	@Length(max = 100, message = "签署方不能超过100个字符")
	@ExcelProperty("签署方")
	@Schema(description = "签署方")
	private String signName;
	/**
	 * 签署方Openid
	 */
	@ExcelAttribute(name = "签署方Openid", maxLength = 100)
	@Length(max = 100, message = "签署方Openid不能超过100个字符")
	@ExcelProperty("签署方Openid")
	@Schema(description = "签署方Openid")
	private String signOpenId;
	/**
	 * 模版ID
	 */
	@ExcelAttribute(name = "模版ID", isNotEmpty = true, errorInfo = "模版ID不能为空", maxLength = 100)
	@NotBlank(message = "模版ID不能为空")
	@Length(max = 100, message = "模版ID不能超过100个字符")
	@ExcelProperty("模版ID")
	@Schema(description = "模版ID")
	private String signTemplateId;
	/**
	 * 模版名称
	 */
	@ExcelAttribute(name = "模版名称", maxLength = 100)
	@Length(max = 100, message = "模版名称不能超过100个字符")
	@ExcelProperty("模版名称")
	@Schema(description = "模版名称")
	private String signTemplateName;
	/**
	 * 模版状态
	 * invalid: 停用;valid: 启用;creating：草稿
	 */
	@ExcelAttribute(name = "模版状态", maxLength = 20)
	@Length(max = 20, message = "模版状态不能超过20个字符")
	@ExcelProperty("模版状态")
	@Schema(description = "模版状态")
	private String signTemplateStatus;
	/**
	 * 创建人
	 */
	@ExcelAttribute(name = "创建人", maxLength = 100)
	@Length(max = 100, message = "创建人不能超过100个字符")
	@ExcelProperty("创建人")
	@Schema(description = "创建人")
	private String creatorMemberName;
	/**
	 * 法大大模版创建时间
	 */
	@ExcelAttribute(name = "法大大模版创建时间", isDate = true)
	@ExcelProperty("法大大模版创建时间")
	@Schema(description = "法大大模版创建时间")
	private LocalDateTime fascCreateTime;
	/**
	 * 最新更新时间
	 */
	@ExcelAttribute(name = "最新更新时间", isDate = true)
	@ExcelProperty("最新更新时间")
	@Schema(description = "最新更新时间")
	private LocalDateTime fascUpdateTime;
	/**
	 * 关联用章名称
	 */
	@ExcelAttribute(name = "关联用章名称", maxLength = 100)
	@Length(max = 100, message = "关联用章名称不能超过100个字符")
	@ExcelProperty("关联用章名称")
	@Schema(description = "关联用章名称")
	private String zhangName;
	/**
	 * 是否免验证签0否1是
	 */
	@ExcelAttribute(name = "是否免验证签0否1是", maxLength = 1, isDataId = true, readConverterExp = "0=否,1=是")
	@Length(max = 1, message = "是否免验证签0否1是不能超过1个字符")
	@ExcelProperty("是否免验证签0否1是")
	@Schema(description = "是否免验证签0否1是")
	private String isMianQian;
	/**
	 * 皖信合同类型
	 */
	@ExcelAttribute(name = "皖信合同类型", maxLength = 32)
	@Length(max = 32, message = "皖信合同类型不能超过32个字符")
	@ExcelProperty("皖信合同类型")
	@Schema(description = "皖信合同类型")
	private String contractType;
	/**
	 * 必填是否已配置0未配置1部分配置2已配置
	 */
	@ExcelAttribute(name = "必填是否已配置", maxLength = 1, isDataId = true, readConverterExp = "0=未配置,1=部分配置,2=已配置")
	@Length(max = 1, message = "必填是否已配置不能超过1个字符")
	@ExcelProperty("必填是否已配置0未配置1部分配置2已配置")
	@Schema(description = "必填是否已配置0未配置1部分配置2已配置")
	private String isMustEdit;
	/**
	 * 发起方ID
	 */
	@ExcelAttribute(name = "发起方ID")
	@ExcelProperty("发起方ID")
	@Schema(description = "发起方ID")
	private String companyActorId;
	/**
	 * 签署方ID
	 */
	@ExcelAttribute(name = "签署方ID")
	@ExcelProperty("签署方ID")
	@Schema(description = "签署方ID")
	private String personActorId;

	@TableField(exist = false)
	@ExcelProperty("当前必填已配置数量")
	private String isMustNow;
	@TableField(exist = false)
	@ExcelProperty("当前必填总数量")
	private String isMustAll;


	/**
	 * 是否删除0否1是
	 */
	@ExcelAttribute(name = "是否删除0否1是", maxLength = 1, isDataId = true, readConverterExp = "0=否,1=是")
	@Length(max = 1, message = "是否删除0否1是不能超过1个字符")
	@ExcelProperty("是否删除0否1是")
	@Schema(description = "是否删除0否1是")
	private String deleteFlag;

}
