/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractInfo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 员工合同
 *
 * @author hgw
 * @date 2022-06-29 20:45:22
 */
@Mapper
public interface TEmployeeContractInfoMapper extends BaseMapper<TEmployeeContractInfo> {

	/**
	 * 员工合同信息表简单分页查询
	 *
	 * @param tEmployeeContractInfo 员工合同信息表
	 * @return
	 */
	IPage<TEmployeeContractInfo> getTEmployeeContractInfoPage(Page<TEmployeeContractInfo> page
			, @Param("tEmployeeContractInfo") TEmployeeContractInfo tEmployeeContractInfo);

	List<TEmployeeContractInfo> getTEmployeeContractList(@Param("tEmployeeContractInfo") TEmployeeContractInfo tEmployeeContractInfo);
	List<EmployeeContractExportVO> getTEmployeeContractExport(@Param("tEmployeeContractInfo") TEmployeeContractInfo tEmployeeContractInfo);

	Integer selectCountContractExport(@Param("tEmployeeContractInfo") TEmployeeContractInfo tEmployeeContractInfo);

	List<EmployeeContractExportVO> getTEmployeeContractExportHistory(@Param("tEmployeeContractInfo") TEmployeeContractInfo tEmployeeContractInfo);

	Integer selectCountHistoryContractExport(@Param("tEmployeeContractInfo") TEmployeeContractInfo tEmployeeContractInfo);

	TEmployeeContractInfo getOneContractByApplyNo(@Param("applyNo") String applyNo);

	/**
	 * 更新项目内的其他的合同在用状态
	 * @Author fxj
	 * @Date 2019-10-17
	 * @param empId
	 * @param deptNo
	 * @param id
	 * @param status
	 * @return
	 **/
	int updateInUseStatusById(@Param("empId")String empId, @Param("deptNo")String deptNo
			, @Param("id")String id, @Param("status")String status);

	/**
	 * @Description: 获取当日合同最大编码
	 * @Author: hgw
	 * @Date: 2022/7/1 15:03
	 * @return: java.lang.String
	 **/
	String getMaxContractCode();

	/**
	 * @param applyNo
	 * @Description: 查询编码是否已存在
	 * @Author: hgw
	 * @Date: 2022/7/5 9:37
	 * @return: java.lang.String
	 **/
	String getContractByApplyNo(@Param("applyNo") String applyNo);

    List<EmployeeContractExportAuditVO> noPageDiy(@Param("tEmployeeContractInfo")TEmployeeContractSearchVo searchVo);

	int noPageCountDiy(@Param("tEmployeeContractInfo")TEmployeeContractSearchVo searchVo);

	/**
	 * B端获取在用合同信息
	 **/
	IPage<EmpContractBusinessPageVo> getContractBusinessPage(Page page, @Param("tEmployeeContractInfo") EmpContractBusinessPageVo tEmployeeContractInfo, @Param("settleDomainIds") List<String> settleDomainIds, @Param("flag") Integer flag);

	/**
	 * B获取3个月内的到期合同提醒
	 **/
	Integer getContractBusinessAlertCount(@Param("tEmployeeContractInfo") EmpContractBusinessPageVo tEmployeeContractInfo
			, @Param("settleDomainIds") List<String> settleDomainIds, @Param("alertMonth")Integer alertMonth);

	List<EmpContractBusinessPageVo> getOtherContractBusinessInfo(@Param("empId")String empId, @Param("contractId")String contractId);

	void updateContractChange(@Param("idCard")String empIdcard, @Param("deptNo")String deptNo, @Param("oldDeptNo")String odlDeptNo);

	String getContractByEmpIdCardAndDeptId(@Param("empIdCard") String empIdCard, @Param("deptId") String deptId);

	String getMinDateByCardAndDeptId(@Param("vo") IdNameNoVo vo);

    void updateContractEnd( @Param("tEmployeeContractInfo")TEmployeeContractInfo tEmployeeContractInfo);

    List<TEmployeeContractInfo> getContractAlertDeptNosList();
}
