/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractAudit;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmployeeContractAuditService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 员工合同审批记录表
 *
 * @author hgw
 * @date 2022-06-30 20:39:54
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/temployeecontractaudit")
@Tag(name = "员工合同审批记录表管理")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TEmployeeContractAuditController {

	private final TEmployeeContractAuditService tEmployeeContractAuditService;

	/**
	 * 获取list
	 *
	 * @param tEmployeeContractAudit 员工合同审批记录表
	 * @return
	 */
	@Operation(summary = "获取list", description = "获取list")
	@PostMapping("/getContractAuditList")
	public R<List<TEmployeeContractAudit>> getContractAuditList(@RequestBody TEmployeeContractAudit tEmployeeContractAudit) {
		return R.ok(tEmployeeContractAuditService.list(Wrappers.query(tEmployeeContractAudit)));
	}

}
