package com.yifu.cloud.plus.v1.business.controller.vacation;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yifu.cloud.plus.v1.business.dto.vacation.UpdateVacationRedundancyDTO;
import com.yifu.cloud.plus.v1.business.query.vacation.TVacationMonitorQuery;
import com.yifu.cloud.plus.v1.business.service.vacation.TVacationMonitorService;
import com.yifu.cloud.plus.v1.business.vo.vacation.TVacationMonitorVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @description: 假期监控表 controller
 * @author: huyc
 * @date: 2023/1/13
*/
@Slf4j
@RestController
@AllArgsConstructor
@RequestMapping("/vacationMonitor")
@Tag(name = "假期监控表相关api")
public class TVacationMonitorController {

    private final TVacationMonitorService tVacationMonitorService;

    /**
     * @description: 分页查询: 条件分页查询
     * @param query 查询条件
     * @return: R<IPage<TVacationMonitorVO>>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "分页查询: 条件分页查询", description = "分页查询: 条件分页查询")
	@GetMapping("/getListByPage")
    public R<IPage<TVacationMonitorVO>> getListByPage(TVacationMonitorQuery query) {
        return this.tVacationMonitorService.getListByPage(query);
    }

    /**
     * @description: 导出：根据查询条件导出
     * @param query 查询条件
     * @return: R<List<TVacationMonitorVO>>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "导出：根据查询条件导出", description = "导出：根据查询条件导出")
	@GetMapping("/exportByParams")
    public R<List<TVacationMonitorVO>> exportByParams(TVacationMonitorQuery query) {
        return this.tVacationMonitorService.exportByParams(query);
    }

    /**
     * @description: 查询-剩余年假：根据身份证号查询剩余年假
     * @param idcard
     * @return: com.yifu.cloud.v1.common.core.util.R<java.math.BigDecimal>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "查询-剩余年假：根据身份证号查询剩余年假", description = "查询-剩余年假：根据身份证号查询剩余年假")
	@GetMapping("getNotUsedVacationDurationByIdCard")
    public R<BigDecimal> getNotUsedVacationDurationByIdCard(@RequestParam("idcard") String idcard) {
        return this.tVacationMonitorService.getNotUsedVacationDurationByIdCard(idcard);
    }

    /**
     * @description: 定时任务：内部服务调用，每天初始化员工年假信息
     * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
    */
    @Inner
    @PostMapping("/inner/buildMonitorDataForCurrentYear")
    public R<Boolean> buildMonitorData() {
        return this.tVacationMonitorService.buildMonitorData();
    }

    /**
     * @description: 冗余更新：更新监控表中冗余的员工信息，电信工号和岗位
     * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    @Inner
    @PostMapping("/inner/updateRedundancyEmployeeFields")
    public void updateRedundancyEmployeeFields(@RequestBody List<UpdateVacationRedundancyDTO> dtoList) {
        tVacationMonitorService.updateRedundancyEmployeeFields(dtoList);
    }

}

