package com.yifu.cloud.plus.v1.business.mapper.salary;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.salary.TSalaryStatisticsPersonal;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsPersonalPageQuery;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsPersonalQuery;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryStatisticsPersonalVO;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryTotalVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @description: 个人薪资变动统计表 mapper
 * @Entity com.yifu.cloud.v1.hrobusiness.api.entity.salary.TSalaryStatisticsPersonal
 * @author: wangweiguo
 * @date: 2021-09-07
*/
@Mapper
public interface TSalaryStatisticsPersonalMapper extends BaseMapper<TSalaryStatisticsPersonal> {

    Page<TSalaryStatisticsPersonalVO> getListByPage(Page<TSalaryStatisticsPersonalVO> page, @Param("query") TSalaryStatisticsPersonalPageQuery query);

    List<TSalaryStatisticsPersonalVO> getListByPage(@Param("query") TSalaryStatisticsPersonalQuery query);

    TSalaryTotalVO sumSalaryPerson(@Param("query") TSalaryStatisticsPersonalQuery query);

}




