package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TBusinessOperate;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author licancan
 * @description 投保详情VO
 * @date 2022-07-20 19:23:17
 */
@Data
@Schema(description = "投保详情VO")
public class InsuranceDetailVO implements Serializable {
	private static final long serialVersionUID = 628032758008497542L;
	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 投保类型， 1新增、3批增、4替换
	 */
	@Schema(description = " 投保类型， 1新增、3批增、4替换")
	private Integer buyType;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String projectName;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 封面抬头
	 */
	@Schema(description = "封面抬头")
	private String invoiceTitle;

	/**
	 * 投保岗位
	 */
	@Schema(description = "投保岗位")
	private String post;

	/**
	 * 保单开始时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单开始时间")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单结束时间")
	private LocalDate policyEnd;

	/**
	 * 保单生效日期
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单生效日期")
	private LocalDate policyEffect;

	/**
	 * 保单编号
	 */
	@Schema(description = "保单编号")
	private String policyNo;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 险种主键
	 */
	@Schema(description = "险种主键")
	private Long insuranceTypeId;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 医疗额度
	 */
	@Schema(description = "医疗额度")
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@Schema(description = "身故或残疾额度")
	private String dieDisableQuota;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 费用类型
	 */
	@Schema(description = "费用类型 0、预估 1、实缴")
	private Integer premiumType;

	/**
	 * 预估保费
	 */
	@Schema(description = "预估保费")
	private BigDecimal estimatePremium;

	/**
	 * 实际保费
	 */
	@Schema(description = "实际保费")
	private BigDecimal actualPremium;

	/**
	 * 发票号
	 */
	@Schema(description = "发票号")
	private String invoiceNo;

	/**
	 * 结算类型 (0、与薪资结算 1、单独结算)
	 */
	@Schema(description = "结算类型 (0、与薪资结算 1、单独结算)")
	private Integer settleType;

	/**
	 * 结算月
	 */
	@Schema(description = "结算月")
	private String settleMonth;

	/**
	 * 投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
	 */
	@Schema(description = "投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	private Integer buyHandleStatus;

	/**
	 * 减员状态 1待减员 2减员中 3减员退回 4减员成功
	 */
	@Schema(description = "减员状态 1待减员 2减员中 3减员退回 4减员成功")
	private Integer reduceHandleStatus;

	/**
	 * 预估结算办理状态 1待结算 2结算中 3已结算
	 */
	@Schema(description = "预估结算办理状态 1待结算 2结算中 3已结算")
	private String estimateSettleStatus;

	/**
	 * 实缴结算办理状态 1待结算 2结算中 3已结算
	 */
	@Schema(description = "实缴结算办理状态 1待结算 2结算中 3已结算")
	private String actualSettleStatus;

	/**
	 * 是否出险 0未出险 1已出险
	 */
	@Schema(description = "是否出险 0未出险 1已出险")
	private Integer isUse;

	/**
	 * 是否有效 0有效 1无效
	 */
	@Schema(description = "是否有效 0有效 1无效")
	private Integer isEffect;

	/**
	 * 是否过期 0未过期 1已过期
	 */
	@Schema(description = "是否过期 0未过期 1已过期")
	private Integer isOverdue;

	/**
	 * 商险购买地省
	 */
	@Schema(description = "商险购买地省")
	private String insuranceProvinceName;

	/**
	 * 商险购买地省code
	 */
	@Schema(description = "商险购买地省code")
	private Integer insuranceProvince;

	/**
	 * 商险购买地市
	 */
	@Schema(description = "商险购买地市")
	private String insuranceCityName;

	/**
	 * 商险购买地市code
	 */
	@Schema(description = "商险购买地市code")
	private Integer insuranceCity;

	/**
	 * 商险办理省
	 */
	@Schema(description = "商险办理省")
	private String insuranceHandleProvinceName;

	/**
	 * 商险办理省code
	 */
	@Schema(description = "商险办理省code")
	private Integer insuranceHandleProvince;

	/**
	 * 商险办理城市
	 */
	@Schema(description = "商险办理城市")
	private String insuranceHandleCityName;

	/**
	 * 商险办理城市code
	 */
	@Schema(description = "商险办理城市code")
	private Integer insuranceHandleCity;

	/**
	 * 创建人姓名
	 */
	@Schema(description = "创建人(派单人)")
	private String createName;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	private LocalDateTime createTime;

	/**
	 * 附件 todo 数据库暂时未关联附件，这个字段没值
	 */
	@Schema(description = "附件：预留字段，暂时都是空")
	private String enclosure;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
	private String remark;

	/**
	 * 计费方式(0：按天，1：按月)
	 */
	@Schema(description = "计费方式(0：按天，1：按月)")
	private Integer billingType;

	/**
	 * 购买周期
	 */
	@Schema(description = "购买周期")
	private String buyCycle;

	/**
	 * 费率
	 */
	@Schema(description = "费率")
	private String rate;

	/**
	 * 派单类型 1新增、3批增、4替换、5减员
	 */
	@Schema(description = "派单类型：1新增、3批增、4替换、5减员")
	private Integer distributeType;

	/**
	 * 派单状态
	 * 减员状态 1待减员 2减员中 3减员退回 4减员成功
	 * 办理状态 1待投保 2投保中 3已投保 4投保退回
	 */
	@Schema(description = "派单状态：派单类型是1、3、4时：1待投保 2投保中 3已投保 4投保退回，派单类型是5时：1待减员 2减员中 3减员退回 4减员成功")
	private Integer distributeStatus;

	/**
	 * 被替换人姓名
	 */
	@Schema(description = "被替换人姓名")
	private String coverEmpName;

	/**
	 * 被替换人身份证号
	 */
	@Schema(description = "被替换人身份证号）")
	private String coverEmpIdcardNo;

	/**
	 * 被替换人项目名称
	 */
	@Schema(description = "被替换人项目名称")
	private String coverProjectName;

	/**
	 * 被替换人封面抬头
	 */
	@Schema(description = "被替换人封面抬头")
	private String coverInvoiceTitle;

	/**
	 * 替换人姓名
	 */
	@Schema(description = "替换人姓名")
	private String replaceEmpName;

	/**
	 * 替换人身份证号
	 */
	@Schema(description = "替换人身份证号")
	private String replaceEmpIdcardNo;

	/**
	 * 替换人项目名称
	 */
	@Schema(description = "被替换人项目名称")
	private String replaceProjectName;

	/**
	 * 替换人封面抬头
	 */
	@Schema(description = "替换人封面抬头")
	private String replaceInvoiceTitle;

	/**
	 * 减员id
	 */
	@Schema(description = "减员id")
	private String refundId;

	/**
	 * 退保金额
	 */
	@Schema(description = "退保金额（减员类型专用）")
	private BigDecimal surrender;

	/**
	 * 退保结算状态 todo 数据库暂时没有
	 */
	@Schema(description = "退保结算状态 ：预留字段，暂时都是空（减员类型专用）")
	private String surrenderSettleStatus;

	/**
	 * 默认结算信息id
	 */
	@Schema(description = "默认结算信息id")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String defaultSettleId;

	/**
	 * 操作记录列表
	 */
	@Schema(description = "操作记录列表")
	List<TBusinessOperate> operateList;

	/**
	 * 忽略提醒 0：忽略 1：不忽略
	 */
	@Schema(description = "有忽略提醒 0：忽略 1：不忽略")
	private String expireIgnoreFlag;

	/**
	 * 消息提醒备注
	 */
	@Schema(description = "消息提醒备注")
	private String expireRemark;

	/**
	 * 是否地市自购0是 1 否
	 */
	@Schema(description = "是否地市自购")
	private String isAdress;
}
