/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.order.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 项目订单附件同步日志信息
 *
 * @author fxj
 * @date 2024-11-15 17:21:46
 */
@Data
public class TOrderFileSyncLogVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@ExcelProperty("主键")
	private String id;

	/**
	 * 项目单号
	 */
	@Length(max = 30, message = "项目单号 不能超过30 个字符")
	@ExcelAttribute(name = "项目单号", maxLength = 30)
	@Schema(description = "项目单号")
	@ExcelProperty("项目单号")
	private String orderNo;

	/**
	 * 附件IDS
	 */
	@Length(max = 500, message = "附件IDS 不能超过500 个字符")
	@ExcelAttribute(name = "附件IDS", maxLength = 500)
	@Schema(description = "附件IDS")
	@ExcelProperty("附件IDS")
	private String attIds;

	/**
	 * 失败原因
	 */
	@ExcelAttribute(name = "失败原因")
	@Schema(description = "失败原因")
	@ExcelProperty("失败原因")
	private String reason;

	/**
	 * 重试结果：0 成功  1 失败
	 */
	@Length(max = 1, message = "重试结果：0 成功  1 失败 不能超过1 个字符")
	@ExcelAttribute(name = "重试结果：0 成功  1 失败", maxLength = 1)
	@Schema(description = "重试结果：0 成功  1 失败")
	@ExcelProperty("重试结果：0 成功  1 失败")
	private String flag;

}
