/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 派单信息记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TDispatchInfoPageVo extends TDispatchInfo {

	/**
	 * 社保户名称
	 */
	@ExcelAttribute(name = "社保户名称", maxLength = 50)
	@Schema(description = "社保户名称" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户名称" )
	private String socialHouseholdName;

	/**
	 * 公积金户名称
	 */
	@ExcelAttribute(name = "公积金户名称", maxLength = 50)
	@Schema(description = "公积金户名称" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户名称" )
	private String providentHouseholdName;

	// 社保办理页面查询使用，判断能否办理
	@Schema(description = "养工失状态：（0空、1待办理、2自动办理中、3继续办理、4终止办理、5人工处理、6成功）" )
	@ExcelProperty("养工失状态" )
	@TableField(exist = false)
	private String ygsHandleStatus;

	@Schema(description = "医生大状态：（0空、1待办理、2自动办理中、3继续办理、4终止办理、5人工处理、6成功）" )
	@TableField(exist = false)
	private String ysdHandleStatus;

}
