/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpInfo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 瓜子档案表
 *
 * @author chenyx
 * @date 2025-06-13 15:19:03
 */
@Mapper
public interface TGzEmpInfoMapper extends BaseMapper<TGzEmpInfo> {
	/**
	 * 瓜子档案表简单分页查询
	 *
	 * @param tGzEmpInfo 瓜子档案表
	 * @return
	 */
	IPage<TGzEmpInfo> getTGzEmpInfoPage(Page<TGzEmpInfo> page, @Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);

	/**
	 * @param offerId
	 * @Description: 查信息
	 * @Author: hgw
	 * @Date: 2025/6/20 15:24
	 * @return: com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpInfo
	 **/
	TGzEmpInfo getInfoByOfferId(@Param("offerId") Integer offerId);

	/**
	 * @Description: 导出前先查条数
	 * @Author: hgw
	 * @Date: 2025/6/18 15:11
	 * @return: int
	 **/
	int getTGzEmpInfoCount(@Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);
	/**
	 * @Description: 导出主表数据
	 * @Author: hgw
	 * @Date: 2025/6/18 15:12
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpInfo>
	 **/
	List<TGzEmpInfoExportMain> getTGzEmpInfoList(@Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);

	// 导出瓜子档案之教育 hgw 2025-6-19 14:32:24
	int getTGzEmpInfoCountEducation(@Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);
	List<TGzEmpInfoExportEducation> getTGzEmpInfoListEducation(@Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);

	// 导出瓜子档案之工作 hgw 2025-6-19 14:32:24
	int getTGzEmpInfoCountWork(@Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);
	List<TGzEmpInfoExportWork> getTGzEmpInfoListWork(@Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);

	// 导出瓜子档案之家庭 hgw 2025-6-19 14:32:24
	int getTGzEmpInfoCountFamily(@Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);
	List<TGzEmpInfoExportFamily> getTGzEmpInfoListFamily(@Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);

	// 导出瓜子档案之技能 hgw 2025-6-19 14:32:24
	int getTGzEmpInfoCountSkill(@Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);
	List<TGzEmpInfoExportSkill> getTGzEmpInfoListSkill(@Param("tGzEmpInfo") TGzEmpInfoSearchVo tGzEmpInfo);

	// 推送瓜子档案信息给瓜子
	TGzEmpInfoPushGzVo getGzEmpInfoToPushGzById(@Param("gzEmpId") String gzEmpId);
	TGzEmpInfoPushGzVoAdress getGzEmpInfoToPushGzByIdAdress(@Param("gzEmpId") String gzEmpId);
	TGzEmpInfoPushGzVoBank getGzEmpInfoToPushGzByIdBank(@Param("gzEmpId") String gzEmpId);
	List<TGzEmpInfoPushGzVoFamily> getGzEmpInfoToPushGzByIdFamily(@Param("gzEmpId") String gzEmpId);
	List<TGzEmpInfoPushGzVoContact> getGzEmpInfoToPushGzByIdContact(@Param("gzEmpId") String gzEmpId);
	List<TGzEmpInfoPushGzVoWork> getGzEmpInfoToPushGzByIdWork(@Param("gzEmpId") String gzEmpId);
	List<TGzEmpInfoPushGzVoEducation> getGzEmpInfoToPushGzByIdEducation(@Param("gzEmpId") String gzEmpId);
	List<TGzEmpInfoPushGzVoSkill> getGzEmpInfoToPushGzByIdSkill(@Param("gzEmpId") String gzEmpId);
	List<TGzEmpInfoPushGzVoAtta> getGzEmpInfoToPushGzByIdAtta(@Param("gzEmpId") String gzEmpId);

	// 推送瓜子档案里的合同
	TGzEmpInfoPushGzContractVo getGzEmpInfoToPushGzByIdContract(@Param("gzEmpId") String gzEmpId);

}
