package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractPre;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmpProjectStatusVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeAutoRegistRevokeVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeContractPreSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeContractPreVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.apache.ibatis.annotations.Param;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 合同待签订任务记录表
 *
 * @author huych
 * @date 2025-06-11 14:15:53
 */
public interface TEmployeeContractPreService extends IService<TEmployeeContractPre> {
    /**
     * 合同待签订任务记录表简单分页查询
     * @param tEmployeeContractPre 合同待签订任务记录表
     * @return
     */
    IPage<TEmployeeContractPre> getTEmployeeContractPrePage(Page<TEmployeeContractPre> page, TEmployeeContractPreSearchVo tEmployeeContractPre);

	List<TEmployeeContractPre> getTEmployeeContractPreNoPage(@Param("tEmployeeContractPre") TEmployeeContractPreSearchVo tEmployeeContractPre);

	/**
	 * 查询合同待签订数量
	 * @param tEmployeeContractPre 查询合同待签订vo
	 * @return
	 */
	long getTEmployeeContractCount(TEmployeeContractPreSearchVo tEmployeeContractPre);

	/**
	 * 导出合同待签订任务记录表
	 * @param response
	 * @param searchVo
	 */
    void listExport(HttpServletResponse response, TEmployeeContractPreSearchVo searchVo);

	/**
	 * 新增合同待签订
	 * @param preVo
	 * @return
	 */
	Boolean saveContractPreInfo(TEmployeeContractPreVo preVo);

	/**
	 * 合同待签订信息单个/批量确认
	 * @param idList id集合
	 * @return
	 */
	R confirm(List<String> idList);

	/**
	 * 合同待签订信息单个/批量发起签署任务
	 * @param idList id集合
	 * @param type 1 手动 2 自动
	 * @return
	 */
	R dispatcherContract(List<String> idList,String type);

	/**
	 * 合同待签订撤销签署
	 * @param registRevokeVoList
	 * @return
	 */
	R revokeSign(List<TEmployeeAutoRegistRevokeVo> registRevokeVoList);

	void pushWxConfrimMessage();

	void pushDisConfrimContracts();

	Boolean checkContractPreIsExit(EmpProjectStatusVo vo);

	/**
	 * 每日晚23:00自动撤销超时电子签署任务
	 * @return R
	 */
	R autoRevokeElectronicSign();

	/**
	 * 每日早9点通知前端客服前一日撤销电子签署情况
	 * @return R
	 */
	R notifyRevokedElectronicSign();

	/**
	 * 每日早9点电子签合同即将超期提醒
	 * @return R
	 */
	R electronicSignExpiringReminder();

	/**
	 * 合同待签订一键催办
	 * @param idList id集合
	 * @return
	 */
	R contractUrg(List<String> idList);
}
