package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.salary.entity.SysMessageSalary;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 最低工资提醒-每月更新一次
 *
 * @author hgw
 * @date 2019-11-21 17:18:10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Tag(name = "最低工资提醒-每月更新一次")
public class SysMessageSalaryHandelExportVo extends SysMessageSalary {
    private static final long serialVersionUID = 1L;


    @Schema(description = "原因大类 根据数据字典来判断")
    @ExcelAttribute(name = "前一月原因大类",  maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.SYS_MESSAGE_SALARY_TYPE, needExport = true)
    private Integer lastOneReasonType;


    @Schema(description = "原因大类 根据数据字典来判断 ")
    @ExcelAttribute(name = "前二月原因大类",  maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.SYS_MESSAGE_SALARY_TYPE, needExport = true)
    private Integer lastTwoReasonType;


    @Schema(description = "原因大类 根据数据字典来判断 ")
    @ExcelAttribute(name = "前三月原因大类", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.SYS_MESSAGE_SALARY_TYPE, needExport = true)
    private Integer lastThreeReasonType;
}
