/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 预入职-员工伤残信息表
 *
 * @author hgw
 * @date 2024-06-17 11:24:01
 */
@Data
@TableName("t_pre_emp_disability_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预入职-员工伤残信息表")
public class TPreEmpDisabilityInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;

	/**
	 * 原ID——用来判断是否从档案查询带出的
	 */
	@Schema(description = "原ID——用来判断是否从档案查询带出的")
	@ExcelIgnore
	private String oldId;
	/**
	 * 预入职主表ID
	 */
	@ExcelAttribute(name = "预入职主表ID", isNotEmpty = true, errorInfo = "预入职主表ID不能为空", maxLength = 32)
	@NotBlank(message = "预入职主表ID不能为空")
	@Length(max = 32, message = "预入职主表ID不能超过32个字符")
	@ExcelProperty("预入职主表ID")
	@Schema(description = "预入职主表ID")
	private String preMainId;
	/**
	 * 员工ID
	 */
	@Schema(description ="员工ID")
	private String empId;

	/**
	 * 员工姓名
	 */
	@Schema(description ="员工姓名")
	private String empName;

	/**
	 * 员工编码
	 */
	@Schema(description ="员工编码")
	private String empCode;

	/**
	 * 身份证号
	 */
	@Schema(description ="身份证号")
	private String empIdcard;

	/**
	 * 传染病名称
	 */
	@Schema(description ="传染病名称")
	private String infectiousName;

	/**
	 * 伤残病名称
	 */
	@Schema(description ="伤残病名称")
	private String disabilityName;

	/**
	 * 伤残等级
	 */
	@Schema(description ="伤残等级")
	private String disabilityLevel;

	/**
	 * 是否工伤标识0是/1否
	 */
	@Schema(description ="是否工伤标识0是/1否")
	private String injuryIdentification;

	/**
	 * 是否职业病0是/1否
	 */
	@Schema(description ="是否职业病 0是/1否")
	private String occupationalDiseaseFlag;

	/**
	 * 是否传染病病 0是/1否
	 */
	@Schema(description ="是否传染病病 0是/1否")
	private String infectiousDiseaseFlag;

	/**
	 * 是否持有残疾人证明 0是/1否
	 */
	@Schema(description ="是否持有残疾人证明 0是/1否")
	private String disabilityFlag;

	/**
	 * 是否从事过井下、高空、高温、特别繁重体力劳动以及有毒有害工种 0是/1否
	 */
	@Schema(description ="是否从事过井下、高空、高温、特别繁重体力劳动以及有毒有害工种 0是/1否")
	private String otherFlag;
	/**
	 * 伤残开始日期
	 */
	@Schema(description ="伤残开始日期")
	private LocalDateTime startTime;

	/**
	 * 伤残结束日期
	 */
	@Schema(description ="伤残结束日期")
	private LocalDateTime endTime;

	/**
	 * 职业病名称
	 */
	@Schema(description ="职业病名称")
	private String occupationalDisease;

	/**
	 * 项目ID
	 */
	@Schema(description ="项目ID")
	private String  settleDomain;

	/**
	 * 0正常1删除作废
	 */
	@TableLogic
	@Schema(description ="0正常1删除作废")
	private String deleteFlag;

	/**
	 * 备注
	 */
	@Schema(description ="备注")
	private String remark;

	/**
	 * @Author fxj
	 * @Description 附件ID
	 * @Date 14:53 2022/6/21
	 **/
	@TableField(exist = false)
	private String attaIds;

}
