package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * B端列表对象
 * @Author fxj
 * @Date 2020-08-25
 * @return
 **/
@Data
public class EmployeeBusinessVo {
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ExcelAttribute(name = "主键", maxLength = 32)
    @Schema(description = "主键", name = "id")
    private String id;
	/**
	 * 人员表主键
	 */
	@Schema(description = "人员表主键", name = "empId")
	private String empId;
    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空")
    @Length(max = 32, message = "姓名不能超过32个字符")
    @ExcelAttribute(name = "姓名", isNotEmpty = true, errorInfo = "姓名不能为空", maxLength = 32)
    @Schema(description = "姓名", name = "empName")
    private String empName;
    /**
     * 身份证号
     */
    @NotBlank(message = "身份证号不能为空")
    @Length(max = 32, message = "身份证号不能超过32个字符")
    @ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 32, isIdCard = true)
    @Schema(description = "身份证号", name = "empIdcard")
    private String empIdcard;
    /**
     * 性别（1.男 2.女）
     */
    @Length(max = 32, message = "性别不能超过32个字符")
    @ExcelAttribute(name = "性别", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.SEX)
    @Schema(description = "性别", name = "empSex")
    private String empSex;

    /**
     * 年龄
     */
    @ExcelAttribute(name = "年龄", errorInfo = "年龄不能为空",needExport = true)
    @Schema(description = "年龄", name = "empAge")
    private Integer empAge;
    /**
     * 出生日期
     */
    @ExcelAttribute(name = "出生日期",isDate =true ,dateFormat = DateUtil.ISO_EXPANDED_DATE_FORMAT)
    @Schema(description = "出生日期", name = "empBirthday")
    private java.sql.Date empBirthday;
    /**
     * 民族
     */
    @Length(max = 32, message = "民族不能超过32个字符")
    @ExcelAttribute(name = "民族", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.NATION)
    @Schema(description = "民族", name = "empNational")
    private String empNational;
    /**
     * 户口性质
     */
    @Length(max = 32, message = "户口类型不能超过32个字符")
    @ExcelAttribute(name = "户口类型", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.HOUSEHOLD_NATURE)
    @Schema(description = "户口类型", name = "empRegisType")
    private String empRegisType;

    /**
     * 银行卡号
     */
    @Length(max = 32, message = "银行卡号不能超过32个字符")
    @ExcelAttribute(name = "银行卡号", maxLength = 32)
    @Schema(description = "银行卡号", name = "empBankNo")
    private String empBankNo;
    /**
     * 开户行
     */
    @Length(max = 32, message = "开户行不能超过32个字符")
    @ExcelAttribute(name = "开户行", maxLength = 32)
    @Schema(description = "开户行", name = "empBankName")
    private String empBankName;

    /**
     * 学历
     */
    @TableField(exist = false)
    @ExcelAttribute(name = "学历", maxLength = 32,isNotEmpty = false,isDataId = true, dataType = ExcelAttributeConstants.EDUCATION)
    @Schema(description = "学历", name = "educationName")
    private String educationName;

    /**
     * 毕业学校
     */
    @TableField(exist = false)
    @ExcelAttribute(name = "毕业学校", maxLength = 64, isNotEmpty = true)
    @Schema(description = "毕业学校", name = "school")
    private String school;

    /**
     * 入职日期
     */
    @ExcelAttribute(name = "入职日期",isDate =true)
    @Schema(description = "入职日期", name = "enjoinDate")
    private LocalDate enjoinDate;
    /**
     * 业务项目
     */
    @Length(max = 32, message = "业务项目不能超过32个字符")
    @ExcelAttribute(name = "业务项目", maxLength = 32,  isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_LABLE)
    @Schema(description = "业务项目", name = "empLabel")
    private String empLabel;

    /**
     * 岗位
     */
    @Length(max = 50, message = "岗位不能超过50个字符")
    @ExcelAttribute(name = "岗位", maxLength = 50)
    @Schema(description = "岗位", name = "post")
    private String post;

    /**
     * 工时制度（数据字典） 1标准工时 2 综合工时 3不定时工时制
     */
    @Length(max = 32, message = "工时制度不能超过32个字符")
    @ExcelAttribute(name = "工时制度", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.WORKING_HOURS)
    @Schema(description = "工时制度（数据字典） 1标准工时 2 综合工时 3不定时工时制", name = "workingHours")
    private String workingHours;
    /**
     * 离职日期
     */
    @ExcelAttribute(name = "离职日期",isDate =true)
    @Schema(description = "离职日期", name = "leaveDate")
    private Date leaveDate;

    /**
     * 离职原因
     */
    @ExcelAttribute(name = "离职原因",isDataId = true, dataType = ExcelAttributeConstants.REDUCE_REASON)
    @Schema(description = "离职原因", name = "leaveReason")
    private String leaveReason;

    /**
     * 离职备注
     */
    @ExcelAttribute(name = "离职备注")
    @Schema(description = "离职备注", name = "leaveRemark")
    private String leaveRemark;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    @Length(max = 32, message = "手机号不能超过32个字符")
    @ExcelAttribute(name = "手机号", errorInfo = "手机号不能为空", maxLength = 32,isPhone = false)
    @Schema(description = "手机号", name = "empPhone")
    private String empPhone;

    /**
     * 备注
     */
    @Length(max = 500, message = "备注不能超过32个字符")
    @ExcelAttribute(name = "备注", maxLength = 500)
    @Schema(description = "备注", name = "remark")
    private String remark;
    /**
     * 是否删除 0未删除/1删除
     */
    @NotBlank(message = "是否删除 0未删除/1删除不能为空")
    @Length(max = 1, message = "是否删除 0未删除/1删除不能超过1个字符")
    @ExcelAttribute(name = "是否删除 0未删除/1删除", errorInfo = "是否删除 0未删除/1删除不能为空", maxLength = 1, isDataId =true, dataType = ExcelAttributeConstants.STATUS_FLAG)
    @Schema(description = "是否删除 0未删除/1删除", name = "deleteFlag")
    private String deleteFlag;
    /**
     * 在职状态 0是/1否
     */
    @NotBlank(message = "在职状态 0是/1否不能为空")
    @Length(max = 1, message = "在职状态 0是/1否不能超过1个字符")
    @ExcelAttribute(name = "在职状态", errorInfo = "在职状态 0是/1否不能为空", maxLength = 1, isDataId =true, dataType = ExcelAttributeConstants.STATUS_FLAG)
    @Schema(description = "在职状态 0是/1否", name = "workFlag")
    private String workFlag;

    /**
     * 所属单位
     */
    @NotBlank(message = "所属单位不能为空")
    @Length(max = 32, message = "所属单位不能超过32个字符")
    @ExcelAttribute(name = "所属单位", isNotEmpty = true, errorInfo = "所属单位编码不能为空", maxLength = 32, isOrgan = true,isDataId = true, dataType = ExcelAttributeConstants.CUSTOMER)
    @Schema(description = "所属单位", name = "belongUnit")
    private String belongUnit;

    /**
     * 结算主体
     */
    @NotBlank(message = "结算主体不能为空")
    @Length(max = 32, message = "结算主体不能超过32个字符")
    @ExcelAttribute(name = "结算主体", isNotEmpty = true, errorInfo = "结算主体编码不能为空", maxLength = 32,isOrgan = true,isDataId = true, dataType = ExcelAttributeConstants.DEPART)
    @Schema(description = "结算主体", name = "settleDomain")
    private String settleDomain;

    /**
     * b端员工工号
     */
    @Schema(description ="电信员工工号")
    private String businessTelecomNumber;

    /**
     * 标签，字典值（英文逗号分割）
     */
    @Schema(description ="标签，字典值（英文逗号分割）")
    private String employeeTags;

    /**
     * 第一学历和专业
     */
    @Schema(description ="第一学历和专业")
    private String firstDegreeAndMajor;

    /**
     * 第一学历院校
     */
    @Schema(description ="第一学历院校")
    private String firstDegreeGraduateSchool;

    /**
     * 最高学历和专业
     */
    @Schema(description ="最高学历和专业")
    private String highestDegreeAndMajor;

    /**
     * 最高学历院校
     */
    @Schema(description ="最高学历院校")
    private String highestDegreeGraduateSchool;

    /**
     * 联系方式
     */
    @Schema(description ="联系方式")
    private String contactInfo;

    /**
     * 档案所在地
     */
    @Schema(description ="档案所在地")
    private String archivesAddr;

    /**
     * 部门名称
     */
    @Schema(description ="部门名称")
    private String departName;

    /**
     * 拓展表id
     */
    @Schema(description ="拓展表id")
    private String extendId;

    /**
     * b端岗位
     */
    private String businessPost;

    /**
     * B端维护的离职时间
     */
    private LocalDate businessLeaveDate;

    /**
     * 入职时间
     */
    @Schema(description ="入职时间")
    private LocalDate businessEnjoinDate;

    /**
     * 部门id
     */
    @Schema(description ="部门id")
    private Integer departId;

    /**
     * 部门编码 对应部门实体中的TreeLogo
     */
    @Schema(description ="部门编码 对应部门实体中的TreeLogo")
    private String departCode;


    @TableField(exist = false)
    private List<String> settleDomainIds;

}
