package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 入职待待完善
 *
 * @author huych
 * @date 2025-03-17 15:23:19
 */
@Data
@ColumnWidth(17)
public class EmployeeRegistrationProjectListVo implements Serializable {

	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;

	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;

	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String employeeName;

	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "手机号码")
	@Schema(description = "手机号码")
	@ExcelProperty("手机号码")
	private String empPhone;

	@ExcelAttribute(name = "入职日期")
	@Schema(description = "入职日期")
	@ExcelProperty("入职日期")
	@DateTimeFormat("yyyy-MM-dd")
	private Date joinLeaveDate;

	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型")
	@ExcelProperty("员工类型")
	private String empNature;

	@ExcelAttribute(name = "合同类型（字典值）", isDataId = true, dataType = ExcelAttributeConstants.PERSONNEL_TYPE)
	@Schema(description = "合同类型（字典值）")
	@ExcelProperty("合同类型")
	private String contractType;

	@ExcelAttribute(name = "前端客服")
	@Schema(description = "前端客服")
	@ExcelProperty("前端客服")
	private String customerUsernameNew;

	@ExcelAttribute(name = "数据来源")
	@Schema(description = "数据来源")
	@ExcelProperty("数据来源")
	private String dataSource;

	@ExcelAttribute(name = "不完善类型")
	@Schema(description = "不完善类型")
	@ExcelProperty("不完善类型")
	private String type;

	@ExcelAttribute(name = "状态")
	@Schema(description = "状态")
	@ExcelProperty("状态")
	private String processStatus;

	@ExcelAttribute(name = "项目档案id" ,isExport = false)
	@Schema(description = "项目档案id")
	@ExcelProperty("项目档案id")
	private String empProjectId;

	@ExcelAttribute(name = "人员档案id",isExport = false)
	@Schema(description = "人员档案id")
	@ExcelProperty("人员档案id")
	private String empInfoId;

	@ExcelAttribute(name = "项目id",isExport = false)
	@Schema(description = "项目id")
	@ExcelProperty("项目id")
	private String deptId;

}

