/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitor;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 档案完整度监控
 *
 * @author huyc
 * @date 2024-06-17 16:08:58
 */
@Mapper
public interface TCompleteMonitorMapper extends BaseMapper<TCompleteMonitor> {
    /**
     * 档案完整度监控简单分页查询
     * @param tCompleteMonitor 档案完整度监控
     * @return
     */
    IPage<TCompleteMonitor> getTCompleteMonitorPage(Page<TCompleteMonitor> page, @Param("tCompleteMonitor") TCompleteMonitorSearchVo tCompleteMonitor);

	/**
	 * 档案待完善列表分页查询
	 * @param employeeRegistrationPre 入职待完善
	 * @return
	 */
	IPage<EmployeeRegistrationProjectListVo> getAllLackArchivesPage(Page<EmployeeRegistrationProjectListVo> page, @Param("employeeRegistrationPre") EmployeeRegistrationPreSearchVo employeeRegistrationPre);

	/**
	 * 入职待完善数量查询
	 * @param employeeRegistrationPre 入职待完善
	 * @return
	 */
	long getAllLackArchivesExportCount(@Param("employeeRegistrationPre") EmployeeRegistrationPreSearchVo employeeRegistrationPre);

	/**
	 * 入职待完善批量导出
	 * @param employeeRegistrationPre 入职待完善
	 * @return
	 */
	List<EmployeeRegistrationProjectListVo> getAllLackArchivesExportList(@Param("employeeRegistrationPre") EmployeeRegistrationPreSearchVo employeeRegistrationPre);

	/**
	 * 档案完整度监控简单分页查询
	 * @param tCompleteMonitor 档案完整度监控
	 * @return
	 */
	long getExportCount(@Param("tCompleteMonitor") TCompleteMonitorSearchVo tCompleteMonitor);


	/**
	 * 档案完整度监控批量导出
	 * @param tCompleteMonitor 档案完整度监控
	 * @return
	 */
	List<TCompleteMonitorVo> getTCompleteMonitorExportList(@Param("tCompleteMonitor") TCompleteMonitorSearchVo tCompleteMonitor);

	/**
	 * 查询人员明细
	 * @param completeMonitorInfoVo
	 * @return
	 */
	IPage<TCompleteMonitorInfoVo> getMonitorEmpInfoList(Page<TCompleteMonitorInfoVo> page,@Param("completeMonitorInfoVo") TCompleteMonitorInfoVo completeMonitorInfoVo);

	/**
	 * 获取所有监控数据
	 * @return
	 */
	List<TCompleteMonitor> getAllMonitorEmpList(@Param("deptNo") String deptNo);

	/**
	 * 删除所有监控数据
	 * @return
	 */
	void deleteAllMonitorInfo();

	/**
	 * 判断项目档案的完整状态
	 * @return
	 */
	List<TCompleteMonitorFlagVo> checkEmpProjectCompleteFlag(@Param("deptNo") String deptNo);

	/**
	 * 根据项目编码删除监控数据
	 * @return
	 */
	void deleteMonitorInfoByDeptNo(@Param("deptNo") String deptNo);

	// 导出详情使用 hgw 2024-6-26 11:05:41
	int getTEmpMainAllCount(@Param("tCompleteMonitor") TCompleteMonitor tCompleteMonitor);
	// 导出详情使用 hgw 2024-6-26 11:05:41
	List<TMainExportAllVO> getTEmpMainAllList(@Param("tCompleteMonitor") TCompleteMonitor tCompleteMonitor);
	List<TMainExportAllVO> getTEmpMainAllListByContract(@Param("empIdList") List<String> empIdList);
	List<TMainExportAllVO> getTEmpMainAllListByEducation(@Param("empIdList") List<String> empIdList);
	List<TMainExportAllVO> getTEmpMainAllListByBad(@Param("empIdList") List<String> empIdList);
	List<TMainExportAllVO> getTEmpMainAllListByDisability(@Param("empIdList") List<String> empIdList);
	List<TMainExportAllVO> getTEmpMainAllListByWork(@Param("empIdList") List<String> empIdList);
	List<TMainExportAllVO> getTEmpMainAllListByFamily(@Param("empIdList") List<String> empIdList);
	List<TMainExportAllVO> getTEmpMainAllListByProfessional(@Param("empIdList") List<String> empIdList);

	// 导出详情使用 hgw 2024-6-26 11:05:41
	int getTEmpMainAllCountOneWork(@Param("tCompleteMonitor") TCompleteMonitor tCompleteMonitor);
	List<TMainExportAllVO> getTEmpMainAllListOneWork(@Param("tCompleteMonitor") TCompleteMonitor tCompleteMonitor);

	int getTEmpMainAllCountTwoFamily(@Param("tCompleteMonitor") TCompleteMonitor tCompleteMonitor);
	List<TMainExportAllVO> getTEmpMainAllListTwoFamily(@Param("tCompleteMonitor") TCompleteMonitor tCompleteMonitor);

	int getTEmpMainAllCountThreeProfessional(@Param("tCompleteMonitor") TCompleteMonitor tCompleteMonitor);
	List<TMainExportAllVO> getTEmpMainAllListThreeProfessional(@Param("tCompleteMonitor") TCompleteMonitor tCompleteMonitor);

}
