package com.yifu.cloud.plus.v1.ekp.controller;

import com.yifu.cloud.plus.v1.ekp.service.EkpManagerInfoService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpIncomePushInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialPushInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpIncomeParamManage;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 
 *
 * @author huyc
 * @date 2024-03-13 16:14:37
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/ekpmanagerinfo" )
@Tag(name = "管理费明细")
public class TEkpManagerInfoController {

    private final EkpManagerInfoService ekpManagerInfoService;

	/**
	 * @param incomeParam
	 * @Description: 推送管理费明细数据
	 * @Author: huyc
	 * @Date: 2024/3/14
	 * @return:
	 **/
	@Inner
	@PostMapping("/inner/pushManangerInfoToEkp")
	public EkpIncomePushInfoVo pushManangerInfoToEkp(@RequestBody EkpIncomeParamManage incomeParam) {
		return ekpManagerInfoService.pushManangerInfoToEkp(incomeParam);
	}

	/**
	 * @param incomeParamList
	 * @Description: 推送管理费明细数据
	 * @Author: huyc
	 * @Date: 2024/3/14
	 * @return:
	 **/
	@Inner
	@PostMapping("/inner/jobPushManagerInfoToEkp")
	public EkpSocialPushInfoVo jobPushManagerInfoToEkp(@RequestBody List<EkpIncomeParamManage> incomeParamList) {
		return ekpManagerInfoService.jobPushManagerInfoToEkp(incomeParamList);
	}
}
