package com.yifu.cloud.plus.v1.yifu.order.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author licancan
 * @description 订单回复表 t_order_reply
 * @date 2022-08-26 17:20:16
 */
@Data
@TableName("t_order_reply")
@Schema(description = "订单回复表")
public class TOrderReply implements Serializable {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 订单编号
     */
	@Schema(description = "订单编号")
    private String orderNo;

    /**
     * 回复内容
     */
	@Schema(description = "回复内容")
    private String replyContent;

    /**
     * 创建人姓名（回复人）
     */
	@Schema(description = "创建人姓名（回复人）")
    private String createName;

    /**
     * 创建时间（回复时间）
     */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间（回复时间）")
    private LocalDateTime createTime;

    /**
     * 删除标识
     */
	@Schema(description = "删除标识")
    private Integer deleteFlag;

    private static final long serialVersionUID = 1L;
}