package com.yifu.cloud.plus.v1.yifu.order.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.order.entity.TOrder;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderDetailVO;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderListParam;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderListVO;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderReplyListVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author licancan
 * @description 针对表【t_order(订单表)】的数据库操作Mapper
 * @date 2022-08-26 17:22:18
 */
@Mapper
public interface TOrderMapper extends BaseMapper<TOrder> {

	/**
	 * 订单列表分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link IPage<OrderListVO>}
	 */
    IPage<OrderListVO> getOrderPageList(Page<OrderListParam> page,@Param("param") OrderListParam param);

	/**
	 * 导出勾选查询结果
	 *
	 * @author licancan
	 * @param idList
	 * @return {@link List<OrderListVO>}
	 */
	List<OrderListVO> getOrderListBySelect(@Param("idList") List<String> idList);

	/**
	 * 导出非勾选查询结果
	 *
	 * @author licancan
	 * @param param
	 * @param userName
	 * @return {@link List< OrderListVO>}
	 */
	List<OrderListVO> getOrderList(@Param("param") OrderListParam param,@Param("userName") String userName);

	/**
	 * 通过id查询详情
	 *
	 * @author licancan
	 * @param id
	 * @return {@link OrderDetailVO}
	 */
    OrderDetailVO getOrderDetailById(@Param("id") String id);

	/**
	 * 订单回复列表分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param orderNo
	 * @return {@link IPage< OrderReplyListVO>}
	 */
	IPage<OrderReplyListVO> getOrderReplyPageList(Page<OrderReplyListVO> page,@Param("orderNo")  String orderNo);
}
