package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class TPaymentBySalaryVo implements Serializable {

	private String id;

	/**
	 * 员工身份证
	 */
	@Length(max = 100, message = "不能超过100个字符")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, maxLength = 100)
	private String empIdcard;

	/**
	 * 单位大病金额
	 */
	@ExcelAttribute(name = "单位大病金额")
	private BigDecimal unitBitmailmentFee;

	/**
	 * 单位社保合计
	 */
	@ExcelAttribute(name = "单位社保合计")
	private BigDecimal unitSocialSum;
	/**
	 * 个人社保合计
	 */
	@ExcelAttribute(name = "个人社保合计")
	private BigDecimal personalSocialSum;

	/**
	 * 单位公积金费用
	 */
	@ExcelAttribute(name = "单位公积金费用")
	private BigDecimal unitFundSum;

	/**
	 * 个人公积金费用
	 */
	@ExcelAttribute(name = "个人公积金费用")
	private BigDecimal personalFundSum;

	/**
	 * 工资社保结算状态  0: 未结算  1: 待结算  2: 已结算
	 */
	@Length(max = 1, message = "工资社保结算状态  0: 未结算  1: 待结算  2: 已结算不能超过1个字符")
	@ExcelAttribute(name = "工资社保结算状态", maxLength = 1, isDataId = true, dataType = "settlement_flag")
	private String salarySocialFlag;
	/**
	 * 工资公积金结算状态  0: 未结算  1: 待结算  2: 已结算
	 */
	@Length(max = 1, message = "工资公积金结算状态  0: 未结算  1: 待结算  2: 已结算不能超过1个字符")
	@ExcelAttribute(name = "工资公积金结算状态", maxLength = 1, isDataId = true, dataType = "settlement_flag")
	private String salaryFundFlag;

	/**
	 * 社保缴纳月份
	 */
	@Length(max = 6, message = "社保缴纳月份不能超过6个字符")
	@ExcelAttribute(name = "社保缴纳月份", maxLength = 6, isInteger = true)
	private String socialPayMonth;
	/**
	 * 社保生成月份
	 */
	@Length(max = 6, message = "社保生成月份不能超过6个字符")
	@ExcelAttribute(name = "社保生成月份", maxLength = 6, isInteger = true)
	private String socialCreateMonth;

	/**
	 * 公积金缴纳月份
	 */
	@Length(max = 6, message = "公积金缴纳月份不能超过6个字符")
	@ExcelAttribute(name = "公积金缴纳月份", maxLength = 6, isInteger = true)
	private String providentPayMonth;
	/**
	 * 公积金生成月份
	 */
	@Length(max = 6, message = "公积金生成月份不能超过6个字符")
	@ExcelAttribute(name = "公积金生成月份", maxLength = 6, isInteger = true)
	private String providentCreateMonth;

	/**
	 * 部门名称
	 */
	@Length(max = 50, message = "部门名称不能超过50个字符")
	@ExcelAttribute(name = "部门名称", isNotEmpty = true, maxLength = 50, isDataId = true)
	private String settleDomainId;

}
