

# minio部署及使用

minio文档地址：https://docs.min.io/docs/

>注意 部署的时候参考官方文档，在网上找的教程 部署可能会出问题

1. docker单机版

   > 此模式下，对于每一份对象数据，minio直接在data下面存储这份数据，不会建立副本，也不会启用纠删码机制。因此，这种模式无论是服务实例还是磁盘都是“单点”，无任何高可用保障，磁盘损坏就表示数据丢失。

   ```shell
   #创建相关目录
   mkdir -p /mnt/minio/data
   #MinIO自定义用户名密码，注意账号密码长度有限制 账号不小于3，密码不小于8
   docker run -d \
       -p 9000:9000 \
       -p 9001:9001 \
       --name miniotest \
       -v /mnt/minio/data:/data \
       -e "MINIO_ROOT_USER=admintest" \
       -e "MINIO_ROOT_PASSWORD=12345678" \
       quay.io/minio/minio server /data --console-address ":9001"
   #访问地址http://x.x.x.x:9001/  注意端口号要对外暴露
   #创建的桶在/mnt/minio/data下
   ```

   > 新版本将控制台和存储服务分开，对外暴露minio控制台的端口这里用的是9001端口，对象存储服务的端口是9000

2. docker单机版纠删码模式

   >Minio使用纠删码 erasure code 和校验和 checksum 来保护数据免受硬件故障和无声数据损坏。 即便您丢失一半数量（N/2）的硬盘，您仍然可以恢复数据。
   >
   >
   >
   >纠删码是一种恢复丢失和损坏数据的数学算法， Minio采用Reed-Solomon code将对象拆分成N/2数据和N/2 奇偶校验块。 这就意味着如果是12块盘，一个对象会被分成6个数据块、6个奇偶校验块，你可以丢失任意6块盘（不管其是存放的数据块还是奇偶校验块），你仍可以从剩下的盘中的数据进行恢复。

   ```shell
   #创建相关目录
   mkdir -p /mnt/minio/{data1,data2,data3,data4,data5,data6,data7,data8}
   #使用Minio Docker镜像，在8块盘中启动Minio服务：
   docker run -d \
     -p 9000:9000 \
     -p 9001:9001 \
     --name minio \
     -v /mnt/minio/data1:/data1 \
     -v /mnt/minio/data2:/data2 \
     -v /mnt/minio/data3:/data3 \
     -v /mnt/minio/data4:/data4 \
     -v /mnt/minio/data5:/data5 \
     -v /mnt/minio/data6:/data6 \
     -v /mnt/minio/data7:/data7 \
     -v /mnt/minio/data8:/data8 \
     -e "MINIO_ROOT_USER=admintest" \
     -e "MINIO_ROOT_PASSWORD=12345678" \
     quay.io/minio/minio server /data{1...8} --console-address ":9001"
   #访问地址http://x.x.x.x:9001/  注意端口号要对外暴露
   #创建的桶在/mnt/minio/{data1,...data8}下
   ```

3. docker集群版

   - [centos7安装docker-compose](https://www.cnblogs.com/xiao987334176/p/12377113.html)

   - docker compose部署https://docs.min.io/docs/deploy-minio-on-docker-compose.html

     ```yaml
     version: '3.7'
     
     # Settings and configurations that are common for all containers
     x-minio-common: &minio-common
       image: quay.io/minio/minio:RELEASE.2022-04-01T03-41-39Z
       command: server --console-address ":16001" --address ":16000" http://minio{1...4}/data{1...2}
       expose:
         - "16000"
         - "16001"
       environment:
         MINIO_ROOT_USER: minio
         MINIO_ROOT_PASSWORD: 12345678
       healthcheck:
         test: ["CMD", "curl", "-f", "http://localhost:16000/minio/health/live"]
         interval: 30s
         timeout: 20s
         retries: 3
     
     # starts 4 docker containers running minio server instances.
     # using nginx reverse proxy, load balancing, you can access
     # it through port 9000.
     services:
       minio1:
         <<: *minio-common
         hostname: minio1
         container_name: com-minio1
         volumes:
           - /data/com/minio/data1-1:/data1
           - /data/com/minio/data1-2:/data2
     
       minio2:
         <<: *minio-common
         hostname: minio2
         container_name: com-minio2
         volumes:
           - /data/com/minio/data2-1:/data1
           - /data/com/minio/data2-2:/data2
     
       minio3:
         <<: *minio-common
         hostname: minio3
         container_name: com-minio3
         volumes:
           - /data/com/minio/data3-1:/data1
           - /data/com/minio/data3-2:/data2
     
       minio4:
         <<: *minio-common
         hostname: minio4
         container_name: com-minio4
         volumes:
           - /data/com/minio/data4-1:/data1
           - /data/com/minio/data4-2:/data2
     
       nginx:
         image: nginx:1.19.2-alpine
         hostname: nginx
         container_name: com-minio-nginx
         volumes:
           - ./nginx.conf:/etc/nginx/nginx.conf:ro
         ports:
           - "16000:16000"
           - "16001:16001"
         depends_on:
           - minio1
           - minio2
           - minio3
           - minio4
     ```
     
     ```shell
     user  nginx;
     worker_processes  auto;
     
     error_log  /var/log/nginx/error.log warn;
     pid        /var/run/nginx.pid;
     
     events {
         worker_connections  4096;
     }
     
     http {
         include       /etc/nginx/mime.types;
         default_type  application/octet-stream;
     
         log_format  main  '$remote_addr - $remote_user [$time_local] "$request" '
                           '$status $body_bytes_sent "$http_referer" '
                           '"$http_user_agent" "$http_x_forwarded_for"';
     
         access_log  /var/log/nginx/access.log  main;
         sendfile        on;
         keepalive_timeout  65;
     
         # include /etc/nginx/conf.d/*.conf;
     
         upstream minio {
             server minio1:16000;
             server minio2:16000;
             server minio3:16000;
             server minio4:16000;
         }
     
         upstream console {
             ip_hash;
             server minio1:16001;
             server minio2:16001;
             server minio3:16001;
             server minio4:16001;
         }
     
         server {
             listen       16000;
             listen  [::]:16000;
             server_name  localhost;
     
             # To allow special characters in headers
             ignore_invalid_headers off;
             # Allow any size file to be uploaded.
             # Set to a value such as 1000m; to restrict file size to a specific value
             client_max_body_size 0;
             # To disable buffering
             proxy_buffering off;
             proxy_request_buffering off;
     
             location / {
                 proxy_set_header Host $http_host;
                 proxy_set_header X-Real-IP $remote_addr;
                 proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
                 proxy_set_header X-Forwarded-Proto $scheme;
     
                 proxy_connect_timeout 300;
                 # Default is HTTP/1, keepalive is only enabled in HTTP/1.1
                 proxy_http_version 1.1;
                 proxy_set_header Connection "";
                 chunked_transfer_encoding off;
     
                 proxy_pass http://minio;
             }
         }
     
         server {
             listen       16001;
             listen  [::]:16001;
             server_name  localhost;
     
             # To allow special characters in headers
             ignore_invalid_headers off;
             # Allow any size file to be uploaded.
             # Set to a value such as 1000m; to restrict file size to a specific value
             client_max_body_size 0;
             # To disable buffering
             proxy_buffering off;
             proxy_request_buffering off;
     
             location / {
                 proxy_set_header Host $http_host;
                 proxy_set_header X-Real-IP $remote_addr;
                 proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
                 proxy_set_header X-Forwarded-Proto $scheme;
                 proxy_set_header X-NginX-Proxy true;
     
                 # This is necessary to pass the correct IP to be hashed
                 real_ip_header X-Real-IP;
     
                 proxy_connect_timeout 300;
                 
                 # To support websocket
                 proxy_http_version 1.1;
                 proxy_set_header Upgrade $http_upgrade;
                 proxy_set_header Connection "upgrade";
                 
                 chunked_transfer_encoding off;
     
                 proxy_pass http://console;
             }
         }
     }
     ```
     
     ```shell
     docker-compose pull
     docker-compose up
     #如果报Failed to Setup IP tables: Unable to enable SKIP DNAT rule:
     #执行 service docker restart 再执行 docker-compose up
     ```
     
   
4. 基本使用（springboot版，后期可以写成一个服务，对外提供feign接口）

   - 引入依赖

     ```java
     				<!-- 目前最新的版本8.3.7 -->
     				<dependency>
                 <groupId>io.minio</groupId>
                 <artifactId>minio</artifactId>
                 <version>8.3.7</version>
             </dependency>
     ```

     

   - 配置对象存储服务

     ```yaml
     #minio配置
     minio:
       url: http://X.X.X.X:9000/  #对象存储服务的URL
       accessKey: minio #Access key账户
       secretKey: 12345678  #Secret key密码
     ```

     

   - minio配置类

     ```java
     @Configuration
     public class MinioConfig {
         @Value("${minio.url}")
         private String url;
         @Value("${minio.accessKey}")
         private String accessKey;
         @Value("${minio.secretKey}")
         private String secretKey;
     
         @Bean
         public MinioClient getMinioClient() {
             MinioClient minioClient = MinioClient.builder().endpoint(url)
                     .credentials(accessKey, secretKey).build();
             return minioClient;
         }
     }
     ```

     

   - minio工具类

     ```java
     @Component
     public class MinioUtil {
         @Resource
         private MinioClient minioClient;
     
         /**
          * 创建一个桶
          */
         public void createBucket(String bucket) throws Exception {
             boolean found = minioClient.bucketExists(BucketExistsArgs.builder().bucket(bucket).build());
             if (!found) {
                 minioClient.makeBucket(MakeBucketArgs.builder().bucket(bucket).build());
             }
         }
     
         /**
          * 上传一个文件
          */
         public void uploadFile(InputStream stream, String bucket, String objectName) throws Exception {
             minioClient.putObject(PutObjectArgs.builder().bucket(bucket).object(objectName)
                     .stream(stream, -1, 10485760).build());
         }
     
         /**
          * 列出所有的桶
          */
         public List<String> listBuckets() throws Exception {
             List<Bucket> list = minioClient.listBuckets();
             List<String> names = new ArrayList<>();
             list.forEach(b -> {
                 names.add(b.name());
             });
             return names;
         }
     
         /**
          * 列出一个桶中的所有文件和目录
          */
         public List<FileInfo> listFiles(String bucket) throws Exception {
             Iterable<Result<Item>> results = minioClient.listObjects(
                     ListObjectsArgs.builder().bucket(bucket).recursive(true).build());
     
             List<FileInfo> infos = new ArrayList<>();
             results.forEach(r->{
                 FileInfo info = new FileInfo();
                 try {
                     Item item = r.get();
                     info.setFilename(item.objectName());
                     info.setDirectory(item.isDir());
                     infos.add(info);
                 } catch (Exception e) {
                     e.printStackTrace();
                 }
             });
             return infos;
         }
     
         /**
          * 下载一个文件
          */
         public InputStream download(String bucket, String objectName) throws Exception {
             InputStream stream = minioClient.getObject(
                     GetObjectArgs.builder().bucket(bucket).object(objectName).build());
             return stream;
         }
     
         /**
          * 删除一个桶
          */
         public void deleteBucket(String bucket) throws Exception {
             minioClient.removeBucket(RemoveBucketArgs.builder().bucket(bucket).build());
         }
     
         /**
          * 删除一个对象
          */
         public void deleteObject(String bucket, String objectName) throws Exception {
             minioClient.removeObject(RemoveObjectArgs.builder().bucket(bucket).object(objectName).build());
         }
     }
     ```

   - 具体使用

     ```java
     @Api(tags = "文件操作接口")
     @Controller
     public class FileController {
         @Resource
         private MinioUtil minioUtil;
     
         @ApiOperation("上传一个文件")
         @RequestMapping(value = "/uploadfile", method = RequestMethod.POST)
         @ResponseBody
         public AjaxResult fileupload(@RequestParam MultipartFile uploadfile, @RequestParam String bucket,
                                      @RequestParam(required=false) String objectName) throws Exception {
             minioUtil.createBucket(bucket);
             if (objectName != null) {
                 minioUtil.uploadFile(uploadfile.getInputStream(), bucket, objectName+"/"+uploadfile.getOriginalFilename());
             } else {
                 minioUtil.uploadFile(uploadfile.getInputStream(), bucket, uploadfile.getOriginalFilename());
             }
             return AjaxResult.success();
         }
     
         @ApiOperation("列出所有的桶")
         @RequestMapping(value = "/listBuckets", method = RequestMethod.GET)
         @ResponseBody
         public AjaxResult listBuckets() throws Exception {
             return AjaxResult.success(minioUtil.listBuckets());
         }
     
         @ApiOperation("递归列出一个桶中的所有文件和目录")
         @RequestMapping(value = "/listFiles", method = RequestMethod.GET)
         @ResponseBody
         public AjaxResult listFiles(@RequestParam String bucket) throws Exception {
             return AjaxResult.success("200", minioUtil.listFiles(bucket));
         }
     
         @ApiOperation("下载一个文件")
         @RequestMapping(value = "/downloadFile", method = RequestMethod.GET)
         @ResponseBody
         public void downloadFile(@RequestParam String bucket, @RequestParam String objectName,
                                  HttpServletResponse response) throws Exception {
             InputStream stream = minioUtil.download(bucket, objectName);
             ServletOutputStream output = response.getOutputStream();
             response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(objectName.substring(objectName.lastIndexOf("/") + 1), "UTF-8"));
             response.setContentType("application/octet-stream");
             response.setCharacterEncoding("UTF-8");
             IOUtils.copy(stream, output);
         }
     
     
         @ApiOperation("删除一个文件")
         @RequestMapping(value = "/deleteFile", method = RequestMethod.GET)
         @ResponseBody
         public AjaxResult deleteFile(@RequestParam String bucket, @RequestParam String objectName) throws Exception {
             minioUtil.deleteObject(bucket, objectName);
             return AjaxResult.success();
         }
     
         @ApiOperation("删除一个桶")
         @RequestMapping(value = "/deleteBucket", method = RequestMethod.GET)
         @ResponseBody
         public AjaxResult deleteBucket(@RequestParam String bucket) throws Exception {
             minioUtil.deleteBucket(bucket);
             return AjaxResult.success();
         }
     }
     ```

5. 针对分布式高可用等需要注意的点

   - 各个服务的桶设置

     ```
     每个服务可以在配置文件中定义自己的桶
     ```

   - 集群高可用可能需要的注意事项

     ```
     1、分布式Minio里所有的节点需要有同样的access秘钥和secret秘钥，这样这些节点才能建立联接。
     2、分布式Minio使用的磁盘里必须是干净的，里面没有数据。
     3、分布式Minio里的节点时间差不能超过3秒，可以使用NTP来保证时间一致。
     4、在Windows下运行分布式Minio处于实验阶段，请悠着点使用。
     ```
   
   - 待补充
   
     